% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_fluview}
\alias{pub_fluview}
\title{CDC FluView ILINet outpatient doctor visits}
\usage{
pub_fluview(
  regions,
  epiweeks = "*",
  ...,
  issues = NULL,
  lag = NULL,
  auth = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{regions}{character. Locations to fetch. Can be any string IDs in
national, HHS region, census division, most states and territories, and so
on. Full list link below.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch in the form
\code{epirange(startweek, endweek)}, where startweek and endweek are of the form
YYYYWW (string or numeric). Defaults to all ("*") dates.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{issues}{\code{\link{timeset}}. Optionally, the issues to fetch. If not set, the
most recent issue is returned. Mutually exclusive with \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{issues}.}

\item{auth}{string. Optionally, restricted access key (not the same as API
key).}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/fluview.html}. For

Obtains information on outpatient inluenza-like-illness (ILI) from U.S.
Outpatient Influenza-like Illness Surveillance Network (ILINet).

more information on ILINet, see
\url{https://gis.cdc.gov/grasp/fluview/fluportaldashboard.html}.
}
\details{
The full list of location inputs can be accessed at
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/src/acquisition/fluview/fluview_locations.py}.
}
\examples{
\dontrun{
pub_fluview(regions = "nat", epiweeks = epirange(201201, 202005))
}
}
\keyword{endpoint}
