% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interfacing.R, R/zzz.R
\name{extending-emmeans}
\alias{extending-emmeans}
\alias{recover_data}
\alias{recover_data.call}
\alias{emm_basis}
\alias{.recover_data}
\alias{.emm_basis}
\alias{.emm_register}
\title{Support functions for model extensions}
\usage{
recover_data(object, ...)

\method{recover_data}{call}(object, trms, na.action, data = NULL, params = "pi", frame, ...)

emm_basis(object, trms, xlev, grid, ...)

.recover_data(object, ...)

.emm_basis(object, trms, xlev, grid, ...)

.emm_register(classes, pkgname)
}
\arguments{
\item{object}{An object of the same class as is supported by a new method.}

\item{...}{Additional parameters that may be supported by the method.}

\item{trms}{The \code{\link{terms}} component of \code{object} (typically with
the response deleted, e.g. via \code{\link{delete.response}})}

\item{na.action}{Integer vector of indices of observations to ignore; or
\code{NULL} if none}

\item{data}{Data frame. Usually, this is \code{NULL}. However, if non-null,
this is used in place of the reconstructed dataset. It must have all of the
predictors used in the model, and any factor levels must match those used
in fitting the model.}

\item{params}{Character vector giving the names of any variables in the model
formula that are \emph{not} predictors. For example, a spline model may involve
a local variable \code{knots} that is not a predictor, but its value is
needed to fit the model. Names of parameters not actually used are harmless,
and the default value \code{"pi"} (the only numeric constant in base R)
is provided in case the model involves it. An example involving splines
may be found at \url{https://github.com/rvlenth/emmeans/issues/180}.}

\item{frame}{Optional \code{data.frame}. Many model objects contain the 
model frame used when fitting the model. In cases where there are no 
predictor transformations, this model frame has all the original predictor
values and so is usable for recovering the data. Thus, if \code{frame} is
non-missing and \code{data} is \code{NULL}, a check is made on \code{trms}
and if there are no function calls, we use \code{data = frame}. This
can be helpful because it provides a modicum of security against the
possibility that the original data used when fitting the model has been
altered or removed.}

\item{xlev}{Named list of factor levels (\emph{excluding} ones coerced to 
factors in the model formula)}

\item{grid}{A \code{data.frame} (provided by \code{ref_grid}) containing 
the predictor settings needed in the reference grid}

\item{classes}{Character names of one or more classes to be registered.
The package must contain the functions \code{recover_data.foo} and
\code{emm_basis.foo} for each class \code{foo} listed in \code{classes}.}

\item{pkgname}{Character name of package providing the methods (usually
should be the second argument of \code{.onLoad})}
}
\value{
The \code{recover_data} method must return a \code{\link{data.frame}}
  containing all the variables that appear as predictors in the model,
  and attributes \code{"call"}, \code{"terms"}, \code{"predictors"},
  and \code{"responses"}. (\code{recover_data.call} will 
  provide these attributes.)

The \code{emm_basis} method should return a \code{list} with the
  following elements:
\describe{
\item{X}{The matrix of linear functions over \code{grid}, having the same
  number of rows as \code{grid} and the number of columns equal to the length
  of \code{bhat}.}
\item{bhat}{The vector of regression coefficients for fixed effects. This
  should \emph{include} any \code{NA}s that result from rank deficiencies.}
\item{nbasis}{A matrix whose columns form a basis for non-estimable functions
  of beta, or a 1x1 matrix of \code{NA} if there is no rank deficiency.}
\item{V}{The estimated covariance matrix of \code{bhat}.}
\item{dffun}{A function of \code{(k, dfargs)} that returns the degrees of
  freedom associated with \code{sum(k * bhat)}.}
\item{dfargs}{A \code{list} containing additional arguments needed for
  \code{dffun}}.
} %%% end of describe

\code{.recover_data} and \code{.emm_basis} are hidden exported versions of 
  \code{recover_data} and \code{emm_basis}, respectively. They run in \pkg{emmeans}'s
  namespace, thus providing access to all existing methods.
}
\description{
This documents the methods that \code{\link{ref_grid}} calls. A user
or package developer may add \pkg{emmeans} support for a model
class by writing \code{recover_data} and \code{emm_basis} methods
for that class. (Users in need for a quick way to obtain results for a model
that is not supported may be better served by the \code{\link{qdrg}} function.)
}
\note{
Without an explicit \code{data} argument, \code{recover_data} returns
   the \emph{current version} of the dataset. If the dataset has changed
   since the model was fitted, then this will not be the data used to fit
   the model. It is especially important to know this in simulation studies
   where the data are randomly generated or permuted, and in cases where
   several datasets are processed in one step (e.g., using \code{dplyr}).
   In those cases, users should be careful to provide the actual data
   used to fit the model in the \code{data} argument.
}
\section{Details}{

To create a reference grid, the \code{ref_grid} function needs to reconstruct
the data used in fitting the model, and then obtain a matrix of linear
functions of the regression coefficients for a given grid of predictor
values. These tasks are performed by calls to \code{recover_data} and
\code{emm_basis} respectively. A vignette giving details and examples
is available via \href{../doc/xtending.html}{vignette("xtending", "emmeans")}

To extend \pkg{emmeans}'s support to additional model types, one need only
write S3 methods for these two functions. The existing methods serve as
helpful guidance for writing new ones.  Most of the work for
\code{recover_data} can be done by its method for class \code{"call"},
providing the \code{terms} component and \code{na.action} data as additional
arguments. Writing an \code{emm_basis} method is more involved, but the
existing methods (e.g., \code{emmeans:::emm_basis.lm}) can serve as models.
Certain \code{recover_data} and \code{emm_basis} methods are exported from
\pkg{emmeans}. (To find out, do \code{methods("recover_data")}.) If your
object is based on another model-fitting object, it
may be that all that is needed is to call one of these exported methods and
perhaps make modifications to the results. Contact the developer if you need
others of these exported.

If the model has a multivariate response, \code{bhat} needs to be
\dQuote{flattened} into a single vector, and \code{X} and \code{V} must be
constructed consistently.

In models where a non-full-rank result is possible (often, you can tell by
seeing if there is a \code{singular.ok} argument in the model-fitting
function), \code{\link{summary.emmGrid}} and its relatives check the
estimability of each
prediction, using the \code{\link[estimability]{nonest.basis}} function in
the \pkg{estimability} package.

The models already supported are detailed in \href{../doc/models.html}{the
"models" vignette}. Some packages may provide additional \pkg{emmeans}
support for its object classes.
}

\section{Communication between methods}{

If the \code{recover_data} method generates information needed by \code{emm_basis},
that information may be incorporated by creating a \code{"misc"} attribute in the
returned recovered data. That information is then passed as the \code{misc} 
argument when \code{ref_grid} calls \code{emm_basis}.
}

\section{Optional hooks}{

Some models may need something other than standard linear estimates and
standard errors. If so, custom functions may be pointed to via the items
\code{misc$estHook}, \code{misc$vcovHook} and \code{misc$postGridHook}. If
just the name of the hook function is provided as a character string, then it
is retrieved using \code{\link{get}}.

The \code{estHook} function should have arguments \samp{(object, do.se, tol,
...)} where \code{object} is the \code{emmGrid} object,
\code{do.se} is a logical flag for whether to return the standard error, and
\code{tol} is the tolerance for assessing estimability. It should return a
matrix with 3 columns: the estimates, standard errors (\code{NA} when
\code{do.se==FALSE}), and degrees of freedom (\code{NA} for asymptotic). The
number of rows should be the same as \samp{object@linfct}. The
\code{vcovHook} function should have arguments \samp{(object, tol, ...)} as
described. It should return the covariance matrix for the estimates. Finally,
\code{postGridHook}, if present, is called at the very end of
\code{ref_grid}; it takes one argument, the constructed \code{object}, and
should return a suitably modified \code{emmGrid} object.
}

\section{Registering S3 methods for a model class}{

The \code{.emm_register} function is provided as a convenience to conditionally 
register your
S3 methods for a model class, \code{recover_data.foo} and \code{emm_basis.foo},
where \code{foo} is the class name. Your package should implement an
\code{.onLoad} function and call \code{.emm_register} if \pkg{emmeans} is
installed. See the example.
}

\examples{
\dontrun{
#--- If your package provides recover_data and emm_grid methods for class 'mymod',
#--- put something like this in your package code -- say in zzz.R:
  .onLoad = function(libname, pkgname) {
    if (requireNamespace("emmeans", quietly = TRUE))
      emmeans::.emm_register("mymod", pkgname)
  }
}
}
\seealso{
\href{../doc/xtending.html}{Vignette on extending emmeans}
}
