% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_put.R
\name{wrf_put}
\alias{wrf_put}
\title{Function to write variables in emission files}
\usage{
wrf_put(file = file.choose(), name = NA, POL)
}
\arguments{
\item{file}{name of file interactively (default) or specified}

\item{name}{name of the variable (any variable)}

\item{POL}{input}
}
\description{
Extract variable
}
\examples{
{
# create the folder and emission file
dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
          wrfchemi_dir = file.path(tempdir(), "EMISS"))

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS"),
                    pattern = "wrfchemi",
                    full.names = TRUE)

# open, put some numbers and write
CO <- wrf_get(file = files[1], name = "E_CO")
CO[] = rnorm(length(CO))
wrf_put(file = files[1], name = "E_CO", POL = CO)
}
}
\seealso{
\code{\link{wrf_plot}} and \code{\link{wrf_get}}
}
\author{
Daniel Schuch
}
