% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EAT.R
\name{EAT}
\alias{EAT}
\title{Efficiency Analysis Trees}
\usage{
EAT(
  data,
  x,
  y,
  numStop = 5,
  fold = 5,
  max.depth = NULL,
  max.leaves = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{data}{Data frame or matrix containing the variables in the model.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{numStop}{Integer. Minimum number of observations in a node for a split to be attempted.}

\item{fold}{Integer. Set of number of folds in which the dataset to apply cross-validation during the pruning is divided.}

\item{max.depth}{Integer. Depth of the tree.}

\item{max.leaves}{Integer. Maximum number of leaf nodes.}

\item{na.rm}{Logical. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
An EAT object containing:
\itemize{
  \item{\code{data} \itemize{
                      \item{\code{df}}: data frame containing the variables in the model.
                      \item{\code{x}}: input indexes in data.
                      \item{\code{y}}: output indexes in data.
                      \item{\code{input_names}}: input variable names.
                      \item{\code{output_names}}: output variable names.
                      \item{\code{row_names}}: rownames in data.}
       }
  \item{\code{control} \itemize{
                        \item{\code{fold}}: fold hyperparameter value.
                        \item{\code{numStop}}: numStop hyperparameter value.
                        \item{\code{max.leaves}}: max.leaves hyperparameter value.
                        \item{\code{max.depth}}: max.depth hyperparameter value.
                        \item{\code{na.rm}}: na.rm hyperparameter value.}
       }
  \item{\code{tree}: list structure containing the EAT nodes.}
  \item{\code{nodes_df}: data frame containing the following information for each node. \itemize{
       \item{\code{id}}: node index.  
       \item{\code{SL}}: left child node index.
       \item{\code{N}}: number of observations at the node. 
       \item{\code{Proportion}}: proportion of observations at the node.
       \item{the output predictions}.
       \item{\code{R}}: the error at the node.  
       \item{\code{index}}: observation indexes at the node.}
       }   
  \item{\code{model} \itemize{
       \item{\code{nodes}}: total number of nodes at the tree.  
       \item{\code{leaf_nodes}}: number of leaf nodes at the tree.
       \item{\code{a}}: lower bound of the nodes. 
       \item{\code{y}}: output predictions.}
       }
}
}
\description{
This function estimates a stepped production frontier through regression trees.
}
\details{
The EAT function generates a regression tree model based on CART \insertCite{breiman1984}{eat} under a new approach that guarantees obtaining a stepped production frontier that fulfills the property of free disposability. This frontier shares the aforementioned aspects with the FDH frontier \insertCite{deprins1984}{eat} but enhances some of its disadvantages such as the overfitting problem or the underestimation of technical inefficiency. More details in \insertCite{esteve2020;textual}{eat}.
}
\examples{
# ====================== #
# Single output scenario #
# ====================== #

simulated <- Y1.sim(N = 50, nX = 3)
EAT(data = simulated, x = c(1, 2, 3), y = 4, numStop = 10, fold = 5, max.leaves = 6)

# ====================== #
#  Multi output scenario #
# ====================== #

simulated <- X2Y2.sim(N = 50, border = 0.1)
EAT(data = simulated, x = c(1,2), y = c(3, 4), numStop = 10, fold = 7, max.depth = 7)

}
\references{
\insertRef{breiman1984}{eat} \cr
\cr
\insertRef{deprins1984}{eat} \cr
\cr
\insertRef{esteve2020}{eat}
}
