% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{create_frame}
\alias{create_frame}
\title{Create a New Frame in Stack}
\usage{
create_frame(
  stack,
  profile = "default",
  handler = ggplot_handler(),
  auto_push = FALSE,
  protocol = NULL,
  config = yaml_config(),
  encryption = NULL,
  check_access = TRUE
)
}
\arguments{
\item{stack}{A name of stack to use.}

\item{profile}{A profile refers to credentials, i.e. username and token. Default profile is named 'default'.}

\item{handler}{A handler which can be specified in the case of custom content,
but by default it is \code{json_handler}.
The system is looking for specified profile as follows:
it looks into working directory to find a configuration file (local configuration),
if the file doesn't exist it looks into user directory to find it (global configuration).
The best way to manage profiles is to have dstack CLI tools installed. These tools are written in Python 3,
so you have to install dstack support. In the case of PyPI you should type

\code{$ pip install dstack}

or

\code{$ conda install -c dstack.ai dstack}

We recommend to use local (virtual) environment to install the package.
You can use this command in console:

\code{$ dstack config --list}

to list existing profiles or add or replace token by following command

\code{$ dstack config --profile <PROFILE>}

or simply

\code{$ dstack config}

if profile is not specified 'default' profile will be created. The system asks you about token
from command line, make sure that you have already obtained token from the site.}

\item{auto_push}{Tells the system to push frame just after commit.
It may be useful if you want to see result immediately. Default is \code{FALSE}.}

\item{protocol}{Protocol to use, usually it is \code{NULL} it means that \code{json_protocol} will be used.}

\item{config}{A configuration, by default it it will be obtained from YAML configuration files, so \code{yaml_config} will be used.}

\item{encryption}{This is a ecryption method. By default is \code{NULL} and no encryption will be used.}

\item{check_access}{Check access to specified stack, default is \code{TRUE}.}
}
\value{
New frame.
}
\description{
Frame is kind of revision of data user is going to publish. It consists of one or more views. Views are usually plots
with some parameters to distinguish one plot from another. This function creates a frame and by default it checks
permission to publish to this stack.
}
\examples{
\donttest{
library(ggplot2)
library(dstack)
image <- qplot(clarity, data = diamonds, fill = cut, geom = "bar")
frame <- create_frame(stack = "diamonds")
frame <- commit(frame, image, "Diamonds bar chart")
print(push(frame)) # print actual stack URL
}
}
