% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_ui.R
\name{imported}
\alias{imported}
\title{List all the imports in the drake cache.}
\usage{
imported(files_only = FALSE, path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search, verbose =
  verbose), verbose = drake::default_verbose(), jobs = 1)
}
\arguments{
\item{files_only}{logical, whether to show imported files only
and ignore imported objects. Since all your functions and
all their global variables are imported, the full list of
imported objects could get really cumbersome.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{+ checks and cache info.}
\item{3:}{+ any potentially missing items.}
\item{4:}{+ imports and writes to the cache.}
}}

\item{jobs}{number of jobs/workers for parallel processing}
}
\value{
Character vector naming the imports in the cache.
}
\description{
An import is a non-target object processed
by \code{\link[=make]{make()}}. Targets in the workflow
plan data frame (see \code{\link[=drake_config]{drake_config()}}
may depend on imports.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Load the canonical example.
make(my_plan) # Run the project, build the targets.
imported() # List all the imported objects/files in the cache.
# For imported files, only the fingerprints/hashes are stored.
})
}
}
\seealso{
\code{\link[=cached]{cached()}}, \code{\link[=loadd]{loadd()}},
\code{\link[=built]{built()}}
}
