% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_render_svg.R
\name{dq_render_svg}
\alias{dq_render_svg}
\title{Render ggplot2 figure as svg}
\usage{
dq_render_svg(
  gg,
  path = NULL,
  width = 1200,
  height = 500,
  alt = "",
  pdf = FALSE,
  png = FALSE,
  delete_file = TRUE
)
}
\arguments{
\item{gg}{reactive or non-reactive ggplot2 object}

\item{path}{directory where images are stored (optional, default = NULL, creates tmp files)}

\item{width}{plot width (optional, default = 1200)}

\item{height}{plot height (optional, default = 500)}

\item{alt}{alternative image title (optional, default = "")}

\item{pdf}{boolean variable controlling if pdf output is generated (optional, default = FALSE)}

\item{png}{boolean variable controlling if png output is generated (optional, default = FALSE)}

\item{delete_file}{parameter for shiny::renderImage function}
}
\value{
list containing ggplot2 figure information
}
\description{
Returns ggplot2 svg image for shiny::imageOutput
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    selectInput("select","Number of bars", choices=c(4,5,6)),
    br(),
    imageOutput("plot")
  ),
  server = function(input, output) {
    gf <- reactive({L <- as.integer(input$select)
                    gg <- ggplot2::ggplot(data=data.frame(x=seq(L), y=seq(L)),
                      ggplot2::aes(x=x, y=y)) + ggplot2::geom_bar(stat = "identity")
    })
    output$plot <- dq_render_svg(gf)
  }
)

}
}
\author{
david.breuer
}
\concept{plotting}
