% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-var.R
\name{select_var}
\alias{select_var}
\title{Select variable}
\usage{
select_var(vars, var = -1)
}
\arguments{
\item{vars}{A character vector of existing column names.}

\item{var}{A variable specified as:
\itemize{
\item a literal variable name
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last column (on the assumption that's the
column you've created most recently).

This argument is taken by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names and column positions).}
}
\value{
The selected column name as an unnamed string.
}
\description{
This function powers \code{\link[=pull]{pull()}} and various functions of the tidyr
package. It is similar to \code{\link[=select_vars]{select_vars()}} but returns only one
column name and has slightly different semantics: it allows
negative numbers to select columns from the end.
}
\examples{
# It takes its argument by expression:
select_var(letters, c)

# Negative numbers select from the end:
select_var(letters, -3)

# You can unquote variables:
var <- 10
select_var(letters, !! var)
}
\seealso{
\code{\link[=pull]{pull()}}, \code{\link[=select_vars]{select_vars()}}
}
\keyword{internal}
