% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-tbl.R
\name{dm_rm_tbl}
\alias{dm_rm_tbl}
\title{Remove tables}
\usage{
dm_rm_tbl(dm, ...)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{...}{One or more unquoted table names to remove from the \code{dm}.
\code{tidyselect} is supported, see \code{\link[dplyr:select]{dplyr::select()}} for details on the semantics.}
}
\value{
The \code{dm} without the removed table(s) that were present in the initial \code{dm}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Removes one or more tables from a \code{\link{dm}}.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_rm_tbl(airports)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dm_add_tbl]{dm_add_tbl()}}, \code{\link[=dm_select_tbl]{dm_select_tbl()}}
}
