% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{plot_na_hclust}
\alias{plot_na_hclust}
\title{Combination chart for missing value}
\usage{
plot_na_hclust(x, main = NULL, col.left = "#009E73", col.right = "#56B4E9")
}
\arguments{
\item{x}{data frames, or objects to be coerced to one.}

\item{main}{character. Main title.}

\item{col.left}{character. The color of left legend that is frequency of NA. default is "#009E73".}

\item{col.right}{character. The color of right legend that is percentage of NA. default is "#56B4E9".}
}
\description{
Visualize distribution of missing value by combination of variables.
}
\details{
Rows are variables containing missing values, and columns are observations. 
These data structures were grouped into similar groups by applying hclust. 
So, it was made possible to visually examine how the missing values are distributed 
for each combination of variables.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Visualize pareto chart for variables with missing value.
plot_na_hclust(carseats)
plot_na_hclust(airquality)
  

# Visualize pareto chart for variables with missing value.
plot_na_hclust(mice::boys)

# Change the main title.
plot_na_hclust(mice::boys, main = "Distribution of missing value")

}
