% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDistribution_Matdist.R
\name{c.Matdist}
\alias{c.Matdist}
\title{Combine Matrix Distributions into a Matdist}
\usage{
\method{c}{Matdist}(...)
}
\arguments{
\item{...}{matrix distributions to be concatenated.}
}
\value{
\link{Matdist}
}
\description{
Helper function for quickly combining distributions into a \link{Matdist}.
}
\examples{
# create three matrix distributions with different column names
mats <- replicate(3, {
  pdf <- runif(200)
  mat <- matrix(pdf, 20, 10, FALSE, list(NULL, sort(sample(1:20, 10))))
  mat <- t(apply(mat, 1, function(x) x / sum(x)))
  as.Distribution(mat, fun = "pdf")
})
do.call(c, mats)
}
