% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_ExoticStatistics.R
\name{ExoticStatistics}
\alias{ExoticStatistics}
\title{Exotic Statistical Methods for Distributions}
\value{
Returns a decorated R6 object inheriting from class SDistribution with the methods listed below
added to the SDistribution methods.
}
\description{
This decorator adds methods for more complex statistical methods including p-norms,
survival and hazard functions and anti-derivatives.
}
\details{
Decorator objects add functionality to the given Distribution object by copying methods
in the decorator environment to the chosen Distribution environment. See the 'Added Methods' section
below to find details of the methods that are added to the Distribution. Methods already
present in the distribution are not overwritten by the decorator.

Use \code{\link{decorate}} to decorate a Distribution.

Methods in this decorator may use numerical approximations and therefore better results may be available
from analytic computations.
}
\section{Constructor}{
 ExoticStatistics$new(distribution)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{distribution} \tab distribution \tab Distribution to decorate. \cr
}
}

\section{Added Methods}{

\tabular{lll}{
\strong{Method} \tab \strong{Name} \tab \strong{Link} \cr
\code{survival(x1, log = FALSE)} \tab Survival function \tab \code{\link{survival}} \cr
\code{hazard(x1, log = FALSE)} \tab Hazard function \tab \code{\link{hazard}} \cr
\code{cumHazard(x1, log = FALSE)} \tab Cumulative hazard function \tab \code{\link{cumHazard}} \cr
\code{cdfAntiDeriv(lower = NULL, upper = NULL))} \tab Anti-derivative of cdf \tab \code{\link{cdfAntiDeriv}} \cr
\code{survivalAntiDeriv(lower = NULL, upper = NULL)} \tab Anti-derivative of survival function \tab \code{\link{survivalAntiDeriv}} \cr
\code{cdfPNorm(p = 2, lower = NULL, upper = NULL)} \tab P-norm of cdf \tab \code{\link{cdfPNorm}} \cr
\code{pdfPNorm(p = 2, lower = NULL, upper = NULL)} \tab P-norm of pdf \tab \code{\link{pdfPNorm}} \cr
\code{survivalPNorm(p = 2, lower = NULL, upper = NULL)} \tab P-norm of survival function \tab \code{\link{survivalPNorm}} \cr
}
}

\examples{
x = Exponential$new()
decorate(x, ExoticStatistics)
x$survival(1)

x = Exponential$new(decorators = ExoticStatistics)
x$survival(4)

}
\seealso{
\code{\link{decorate}}, \code{\link{listDecorators}}
}
