% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.matrix.R
\name{boot.matrix}
\alias{boot.matrix}
\title{Bootstraps and rarefies data.}
\usage{
boot.matrix(data, bootstraps = 100, rarefaction = FALSE, dimensions,
  verbose = FALSE, boot.type = "full")
}
\arguments{
\item{data}{A \code{matrix} or a list of matrices (typically output from \link{chrono.subsets} or \link{custom.subsets} - see details).}

\item{bootstraps}{The number of bootstrap pseudoreplicates (\code{default = 100}).}

\item{rarefaction}{Either a \code{logical} value whether to fully rarefy the data or a set of \code{numeric} values used to rarefy the data (see details).}

\item{dimensions}{Optional, a \code{numeric} value or proportion of the dimensions to keep.}

\item{verbose}{A \code{logical} value indicating whether to be verbose or not.}

\item{boot.type}{The bootstrap algorithm to use (\code{default = "full"}; see details).}
}
\value{
This function outputs a \code{dispRity} object containing:
\item{matrix}{the multidimensional space (a \code{matrix}).}
\item{call}{A \code{list} containing the called arguments.}
\item{subsets}{A \code{list} containing matrices pointing to the elements present in each subsets.}

Use \link{summary.dispRity} to summarise the \code{dispRity} object.
}
\description{
Bootstraps and rarefies either a matrix or a list of matrices.
}
\details{
\code{rarefaction}: when the input is \code{numeric}, the number of elements is set to the value(s) for each bootstrap. If some subsets have fewer elements than the rarefaction value, the subsets is not rarefied.
\code{boot.type}: the different bootstrap algorithms are:
\itemize{
  \item \code{"full"}: resamples all the rows of the matrix and replaces them with a new random sample of rows (with \code{replace = TRUE}, meaning all the elements can be duplicated in each bootstrap).
  \item \code{"single"}: resamples only one row of the matrix and replaces it with a new randomly sampled row (with \code{replace = FALSE}, meaning that only one element can be duplicated in each bootstrap).
}
}
\examples{
## Load the Beck & Lee 2014 matrix
data(BeckLee_mat50)

## Bootstrapping a matrix
## Bootstrapping an ordinated matrix 20 times
boot.matrix(BeckLee_mat50, bootstraps = 20)
## Bootstrapping an ordinated matrix with rarefaction
boot.matrix(BeckLee_mat50, bootstraps = 20, rarefaction = TRUE)
## Bootstrapping an ordinated matrix with only elements 7, 10 and 11 sampled
boot.matrix(BeckLee_mat50, bootstraps = 20, rarefaction = c(7, 10, 11))
## Bootstrapping an ordinated matrix with only 3 dimensions
boot.matrix(BeckLee_mat50, bootstraps = 20, dimensions = 3)

## Bootstrapping a subsets of matrices
## Generating a dummy subsets of matrices
ordinated_matrix <- matrix(data = rnorm(90), nrow = 10, ncol = 9,
                           dimnames = list(letters[1:10]))
matrix_list <- custom.subsets(ordinated_matrix, list(A = 1:5, B = 6:10))
## Bootstrapping the subsets of matrices 20 times (each)
boot.matrix(matrix_list, bootstraps = 20)

}
\seealso{
\code{\link{cust.subsets}}, \code{\link{chrono.subsets}}, \code{\link{dispRity}}.
}
\author{
Thomas Guillerme
}
