% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_afcm_utils.R
\name{e_afcmvar_3D}
\alias{e_afcmvar_3D}
\title{AFCM plot of variables in 3D}
\usage{
e_afcmvar_3D(modelo, axes = c(1, 2, 3), colorVar = "forestgreen")
}
\arguments{
\item{modelo}{an object of class AFCM [FactoMineR].}

\item{axes}{a numeric vector of length 3 specifying the dimensions to be plotted.}

\item{colorVar}{a color for the variables well represented.}
}
\value{
echarts4r plot
}
\description{
AFCM plot of variables in 3D
}
\examples{
data("poison", package = "FactoMineR")
poison.active <- poison[1:55, 5:15]
p <- FactoMineR::MCA(poison.active, graph = FALSE)
e_afcmvar_3D(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
