#' Key of Correct Answers for \code{MSATBtest} Data Set
#'
#' @docType data
#' @description The \code{MSATBkey} is a vector of factors representing correct answers of
#' \code{MSATBtest} data set.
#'
#' @usage data(MSATBkey)
#'
#' @author
#' Adela Drabinova \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' Faculty of Mathematics and Physics, Charles University \cr
#' adela.drabinova@gmail.com \cr
#'
#' Patricia Martinkova \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' martinkova@cs.cas.cz \cr
#'
#' @references
#' Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
#' Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement. Accepted.
#'
#' Drabinova, A. & Martinkova P. (2016). Detection of Differenctial Item Functioning Based on
#' Non-Linear Regression, Technical Report, V-1229, \url{http://hdl.handle.net/11104/0259498}.
#'
#' Vlckova, K. (2014). Test and Item Fairness (Unpublished master's thesis).
#'
#' @keywords datasets
#'
#' @seealso \code{\link{MSATB}}, \code{\link{MSATBtest}}
#'
#' @format A data frame with 20 values representing correct answers to items of \code{MSATBtest}
#' data set. For more details see \code{\link{MSATBtest}}.
#' @docType data
"MSATBkey"
