% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VacuityIndex.R
\name{VacuityIndex}
\alias{VacuityIndex}
\title{Calculates the vacuity index, the proportion of fish which contain food in their stomach.}
\usage{
VacuityIndex(StomachData)
}
\arguments{
\item{StomachData}{Object of class data frame containing stomach data. The data frame must be set
up as follows. The first column should contain the specimen identifier, the second column the 
stomach weight.}
}
\value{
Numeric vector of length one with the calculated vacuity index.
}
\description{
This function calculates the vacuity index, the frequency of fish which lack food in 
their stomach.
}
\details{
This function calculates the vacuity index (Hureau, 1970). This is simply the percentage
ofempty stomachs. The function takes a data frame of stomach data, which should be formatted as 
follows. The first column should contain the specimen identifier and the second column should 
contain the weight of the stomach contents. If users also have information on fish weight, they can calculate the
Gastro-somatic index, using the function GastrosomaticIndex, which has an option to calculate the 
vaucity index utilizing this function.
}
\examples{
data(SebastesStomachs)#load example data
My.Vacuity <- VacuityIndex(StomachData = SebastesStomachs)
}
\references{
Hureau J-C. 1970. Biologie comparee de quelques poissons antarctiques (Nototheniidae). Bulletin de l'Institut Oceanographique de Monaco 68:1-244.
}
\seealso{
\code{\link{GastrosomaticIndex}}
}
\author{
Samuel Borstein
}
