% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{harcourtYee_82}
\alias{harcourtYee_82}
\title{Harcourt and Yee equation of development rate as a function of temperature.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\usage{
harcourtYee_82
}
\description{
Harcourt, D. and Yee, J. (1982) Polynomial algorithm for predicting the duration of insect
life stages. Environmental Entomology, 11, 581-584.
}
\details{
Equation:
\deqn{rT = a0 + a1 * T + a2 * T^{2} + a3 * T^{3}}{%
      rT = a0 + a1 * T + a2 * T^2 + a3 * T^3}

where rT is the development rate, T the temperature, and a0, a1, a2, and a3 are
constants.
}
\references{
\doi{10.1093/ee/11.3.581}
}
\keyword{datasets}
