% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_tif}
\alias{write_tif}
\title{Write an integer array to disk as a tiff image.}
\usage{
write_tif(img, file_name, na = "error", rds = TRUE)
}
\arguments{
\item{img}{An integer array.}

\item{file_name}{The name of the tif file (with or without the .tif) that you
wish to write.}

\item{na}{How do you want to treat \code{NA} values? R can only write integer
values (and hence not \code{NA}s) to tiff pixels. \code{na = 'saturate'} sets them to
saturated value. \code{na = 'zero'} sets them to zero, while \code{na = 'error'} will
give an error if the image contains \code{NA}s. You can also specify directly
here a natural number (must be between 0 and 2 ^ 32 - 1) to use in place of
\code{NA}s.}

\item{rds}{In addition to writing a TIFF file, do you want to save an RDS (a
single R object) file?}
}
\description{
This function allows you to write integer-valued arrays to disk as tiff files
as you would want, which is cumbersome with \code{\link[tiff:writeTIFF]{tiff::writeTIFF()}}.
}
\examples{
img <- read_tif(system.file('extdata', 'bleached.tif', package = 'detrendr'),
                 n_ch = 1)
setwd(tempdir())
write_tif(img, 'bleached.tif')
suppressWarnings(file.remove(list.files()))  # cleanup

}
