% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extreme_efficient.R
\name{extreme_efficient}
\alias{extreme_efficient}
\title{Extreme efficient DMUs}
\usage{
extreme_efficient(datadea,
             dmu_ref = NULL,
             rts = c("crs", "vrs", "nirs", "ndrs"),
             tol = 1e-6)
}
\arguments{
\item{datadea}{A \code{deadata} object with \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set,
i.e. the cluster of DMUs from which we want to find an extreme efficient DMUs subset.
If \code{NULL} (default), all DMUs are considered.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing) or "ndrs" (non-decreasing).}

\item{tol}{Numeric, a tolerance margin for checking efficiency. It is 1e-6 by default.}
}
\value{
A numeric vector representing an extreme efficient subset of DMUs.
}
\description{
Find a set of extreme efficient DMUs from a \code{deadata} object.
}
\examples{
data("PFT1981")
datadea <- make_deadata(PFT1981,
                        ni = 5,
                        no = 3)
# We find an extreme efficient subset from a cluster formed by the first 20 DMUs
result <- extreme_efficient(datadea = datadea,
                            dmu_ref = 1:20)

}
\references{
Charnes, A.; Cooper, W.W.; Thrall, R.M. (1991) "A structure for classifying
and characterizing efficiency and inefficiency in data envelopment analysis",
Journal of Productivity Analisys, 2, 197–237.
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
