% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_namespace.R
\name{var_namespace}
\alias{var_namespace}
\alias{var_namespace<-}
\alias{get_variable_namespaces}
\alias{namespace_attribute}
\alias{get_namespace_attribute}
\alias{set_namespace_attribute}
\alias{namespace_attribute<-}
\title{Get or Set the Namespace of a Variable}
\usage{
var_namespace(x, ...)

var_namespace(x) <- value

get_variable_namespaces(x, ...)

namespace_attribute(x)

get_namespace_attribute(x)

set_namespace_attribute(x, value)

namespace_attribute(x) <- value
}
\arguments{
\item{x}{A vector.}

\item{...}{Additional arguments for method compatibility with other classes.}

\item{value}{A character string specifying the namespace, or \code{NULL} to
remove it.}
}
\value{
A character string representing the namespace attribute of a vector
constructed with \code{\link[=defined]{defined()}}. Returns the updated object (in setter forms).
}
\description{
Retrieve or assign the namespace part of a permanent, global variable
identifier, independent of the current R session or instance.
}
\details{
The \code{namespace} attribute is useful when working with remote, linked, or
open data sources. Variable identifiers in such datasets are often qualified
with a common namespace prefix. When combined, the prefix and namespace form
a persistent URI or IRI for the variable.

Retaining the namespace ensures the identifiers remain valid and resolvable
during validation, merging, or future updates of the vector (such as when it
is used as a column in a dataset).

\code{get_variable_namespaces()} is an alias for \code{var_namespace()}.
\code{namespace_attribute()} and \code{set_namespace_attribute()} are internal helpers.

For full usage, see:
\code{vignette("defined", package = "dataset")} <U+2014> demonstrating integration of
variable labels, namespaces, units of measure, and machine-independent
identifiers.
}
\examples{
# Define a vector with a namespace
x <- defined("Q42", namespace = c(wd = "https://www.wikidata.org/wiki/"))

# Get the namespace
var_namespace(x)
get_variable_namespaces(x)

# Set the namespace
var_namespace(x) <- "https://example.org/ns/"

# Remove the namespace
var_namespace(x) <- NULL

# Use lower-level helpers (not typically used directly)
namespace_attribute(x)
namespace_attribute(x) <- "https://example.org/custom/"

}
\seealso{
Other defined metadata methods and functions: 
\code{\link{var_label}()},
\code{\link{var_labels}()},
\code{\link{var_unit}()}
}
\concept{defined metadata methods and functions}
