% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxr_er_fit.R
\name{cxr_er_fit}
\alias{cxr_er_fit}
\title{General optimization for effect-response models}
\usage{
cxr_er_fit(
  data,
  model_family = c("BH"),
  covariates = NULL,
  optimization_method = c("Nelder-Mead", "BFGS", "CG", "ucminf", "L-BFGS-B", "nlm",
    "nlminb", "Rcgmin", "Rvmmin", "spg", "bobyqa", "nmkb", "hjkb", "nloptr_CRS2_LM",
    "nloptr_ISRES", "nloptr_DIRECT_L_RAND", "DEoptimR", "hydroPSO", "GenSA"),
  lambda_cov_form = c("none", "global"),
  effect_cov_form = c("none", "global"),
  response_cov_form = c("none", "global"),
  initial_values = list(lambda = 1, effect = 1, response = 1, lambda_cov = 0,
    effect_cov = 0, response_cov = 0),
  lower_bounds = NULL,
  upper_bounds = NULL,
  fixed_terms = NULL,
  bootstrap_samples = 0
)
}
\arguments{
\item{data}{either a list of dataframes or a single dataframe. if 'data' is a list, each element is a dataframe with the following columns:
\itemize{
\item fitness: fitness metric for each observation
\item neighbours: named columns giving the number of neighbours of each column
the names of the list elements are taken to be the names of the focal species.
}

If 'data' is a dataframe, it also needs a 'focal' column.
Regardless of the data structure, all focal species need to have the same number of observations (i.e. same number of rows),
and the set of neighbour species needs to be the same as the set of focal species, so that
the neighbours columns correspond to the names of the list elements or, if 'data' is a dataframe,
to the values of the 'focal' column. Future versions will relax this requirement.}

\item{model_family}{family of model to use. Available families are BH (Beverton-Holt), LV (Lotka-Volterra),
RK (Ricker), and LW (Law-Watkinson). Users may also define their own families and models (see vignette 4).}

\item{covariates}{a data structure equivalent to 'data', in which each column are the values of a covariate.}

\item{optimization_method}{numerical optimization method.}

\item{lambda_cov_form}{form of the covariate effects on lambda. Either "none" (no covariate effects) or "global" (one estimate per covariate).}

\item{effect_cov_form}{form of the covariate effects on competitive effects.
Either "none" (no covariate effects) or "global" (one estimate per covariate)}

\item{response_cov_form}{form of the covariate effects on competitive responses.
Either "none" (no covariate effects) or "global" (one estimate per covariate)}

\item{initial_values}{list with components "lambda","effect","response", and optionally
"lambda_cov", "effect_cov", "response_cov", specifying the initial values
for numerical optimization. Single values are allowed.}

\item{lower_bounds}{optional list with single values for "lambda", "effect","response",
and optionally "lambda_cov", "effect_cov", "response_cov".}

\item{upper_bounds}{optional list with single values for "lambda", "effect","response",
and optionally "lambda_cov", "effect_cov", "response_cov".}

\item{fixed_terms}{optional list specifying which model parameters are fixed.}

\item{bootstrap_samples}{number of bootstrap samples for error calculation. Defaults to 0, i.e. no error is calculated.}
}
\value{
an object of class 'cxr_er_fit' which is a list with the following components:
\itemize{
\item model_name: string with the name of the fitness model
\item model: model function
\item data: data supplied
\item taxa: names of the taxa fitted
\item covariates: covariate data supplied
\item optimization_method: optimization method used
\item initial_values: list with initial values
\item fixed_terms: list with fixed terms
\item lambda: fitted values for lambdas, or NULL if fixed
\item effect: fitted values for competitive effects, or NULL if fixed
\item response: fitted values for competitive responses, or NULL if fixed
\item lambda_cov: fitted values for effect of covariates on lambdas, or NULL if fixed
\item effect_cov: fitted values for effect of covariates on competitive effects, or NULL if fixed
\item response_cov: fitted values for effect of covariates on competitive responses, or NULL if fixed
\item lambda_standard_error: standard errors for lambdas, if calculated
\item effect_standard_error: standard errors for competitive effects, if calculated
\item response_standard_error: standard errors for competitive responses, if calculated
\item lambda_cov_standard_error: standard errors for effect of covariates on lambdas, if calculated
\item effect_cov_standard_error: standard errors for effect of covariates on competitive effects, if calculated
\item response_cov_standard_error: standard errors for effect of covariates on competitive responses, if calculated
\item log_likelihood: log-likelihood of the fits
}
}
\description{
Estimates parameters of user-specified models of competitive effects and responses.
}
\examples{
\donttest{
# fit three species at once
data("neigh_list")
# these species all have >250 observations
example_sp <- c("BEMA","LEMA","HOMA")
sp.pos <- which(names(neigh_list) \%in\% example_sp)
data <- neigh_list[sp.pos]
n.obs <- 250
# keep only fitness and neighbours columns
for(i in 1:length(data)){
  data[[i]] <- data[[i]][1:n.obs,c(2,sp.pos+2)]#2:length(data[[i]])]
}

# covariates: salinity
data("salinity_list")
salinity <- salinity_list[example_sp]
# keep only salinity column
for(i in 1:length(salinity)){
  salinity[[i]] <- salinity[[i]][1:n.obs,2:length(salinity[[i]])]
}

initial_values = list(lambda = 1, 
                     effect = 1, 
                     response = 1
                     # lambda_cov = 0, 
                     # effect_cov = 0, 
                     # response_cov = 0
)
lower_bounds = list(lambda = 0, 
                   effect = 0, 
                   response = 0
                   # lambda_cov = 0, 
                   # effect_cov = 0, 
                   # response_cov = 0
)
upper_bounds = list(lambda = 100, 
                    effect = 10, 
                    response = 10
                   # lambda_cov = 0, 
                   # effect_cov = 0, 
                   # response_cov = 0
)

er_3sp <- cxr_er_fit(data = data,
                     model_family = "BH",
                     # fit without covariates, 
                     # as it may be very computationally expensive
                     # covariates = salinity,
                     optimization_method = "bobyqa",
                     lambda_cov_form = "none",
                     effect_cov_form = "none",
                     response_cov_form = "none",
                     initial_values = initial_values,
                     lower_bounds = lower_bounds,
                     upper_bounds = upper_bounds,
                     # syntaxis for fixed values
                     # fixed_terms = list("response"),
                     bootstrap_samples = 3)
# brief summary
summary(er_3sp)
}
}
