% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\name{cosinor.detect}
\alias{cosinor.detect}
\title{Rhythm Detection Test}
\usage{
cosinor.detect(x)
}
\arguments{
\item{x}{An object of the \code{cosinor.lm} or \code{population.cosinor.lm} class.}
}
\description{
Performs the rhythm detection test, a global test for the significance of the estimated model for single cosinor and population-mean cosinor.
}
\details{
The rhythm detection test, also called the zero-amplitude test, tests the overall significance of the cosinor model. The test is actually an F-ratio and is calculated as following (according to the procedure described in Cornélissen, 2014):
\deqn{F = \frac{\frac{\sum(\widehat{Y}_i - \bar{Y})^2}{2}}{\frac{\sum(Y_i - \bar{Y})^2}{N - 3}}} with \eqn{df_1 = 2} and \eqn{df_2 = N - 3}
, where \eqn{\widehat{Y}_i} is the \eqn{i}th estimated value, \eqn{Y_i} is the \eqn{i}th observed value, \eqn{\bar{Y}} is the arithmetic mean of observed values and \eqn{N} is the number of timepoints.
For the population-mean cosinor model, the test is calculated according to the procedure described in Bingham et al. (1982) as follows:
\deqn{F = \frac{k(k-2)}{2(k-1)}\frac{1}{1-(\frac{\widehat{\sigma}_{\beta\gamma}}{\widehat{\sigma}_\beta \widehat{\sigma}_\gamma})^2}[\frac{\beta^2}{\widehat{\sigma}^2_\beta}-2\frac{\widehat{\sigma}_{\beta\gamma}}{\widehat{\sigma}_\beta \widehat{\sigma}_\gamma}\frac{\beta \gamma}{\widehat{\sigma}_\beta \widehat{\sigma}_\gamma}+\frac{\gamma^2}{\widehat{\sigma}^2_\gamma}]} with \eqn{df_1 = 2} and \eqn{df_2 = k - 2}
, where \eqn{k} is the number of subjects in the population, \eqn{\widehat{\sigma}_\beta} and \eqn{\widehat{\sigma}_\gamma} are standard deviations of population \eqn{\beta} and \eqn{\gamma} coefficients and \eqn{\widehat{\sigma}_{\beta\gamma}} is the covariance of population \eqn{\beta} and \eqn{\gamma} coefficients.
}
\examples{
fit.temperature<-cosinor.lm(Temperature~time(Time), period = 24, data = temperature_zg)
cosinor.detect(fit.temperature)

fit.november<-population.cosinor.lm(data = PANAS_november, time = PANAS_time,
period = 7)
cosinor.detect(fit.november)
}
\references{
Cornélissen, G. (2014). Cosinor-Based Rhythmometry. \emph{Theoretical Biology and Medical Modeling}, \emph{11}, Article 16.

Bingham, C., Arbogast, B., Guillaume Cornélissen, G., Lee, J.K. & Halberg, F. (1982). Inferential Statistical Methods for Estimating and Comparing Cosinor Parameters. \emph{Chronobiologia}, \emph{9(4)}, 397-439.
}
