% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deque.R
\docType{class}
\name{Deque}
\alias{Deque}
\title{Deque (double-ended queue)}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Deque
}
\description{
Deques are a generalization of stacks and queues typically
with methods to add, remove and access elements at both sides of the
underlying data sequence. As such, the \code{\link[container]{Deque}} can also be
used to mimic both stacks and queues.
}
\details{
Inherits from \code{\link[container]{Container}} and extends it by
\code{pop} and \code{peek} methods, element counting, and reverse and rotate
functionality.
}
\section{Inherited methods}{

Inherits all methods from \code{\link[container]{Container}} class.
}

\section{R6 constructor}{

\code{Deque$new(x=list())}
}

\section{Deque methods}{

\describe{
 \item{\code{addleft(elem)}}{Add \code{elem} to left side of the \code{Deque}.}
 \item{\code{count(elem)}}{Count number of \code{elem} occurences.}
 \item{\code{pop()}}{Remove and return element from the right side of the
 \code{Deque}.}
 \item{\code{popleft()}}{Remove and return an element from the left side of
 the \code{Deque}.}
 \item{\code{peek()}}{Peek at last element on the right side without removing it.}
 \item{\code{peekleft()}}{Peek at first element on the left side without
 removing it.}
 \item{\code{reverse()}}{Reverse all elements of the \code{Deque} in-place.}
 \item{\code{rotate(n=1)}}{Rotate the \code{Deque} elements n steps to the
     right. If n is negative, rotate to the left.}
}
}

\examples{
# addleft
d <- Deque$new(1L)$addleft(2)
d$values()                                          # 2 1
Deque$new(0L)$addleft(3:1)$values()                 # 3 2 1 0

# count
Deque$new(c("Lisa", "Bob", "Bob"))$count("Bob")     # 2

# peek and pop
d <- Deque$new(1:3)
d$peek()                # 3
d$pop()                 # 3
d$pop()                 # 2
d$pop()                 # 1
#' \dontrun{
#' d$pop()              # Error: pop at empty Deque
#' }

Deque$new(1:3)$reverse()$values()   # 3 2 1

Deque$new(1:3)$rotate()$values()    # 3 1 2
Deque$new(1:3)$rotate(2)$values()   # 2 3 1
Deque$new(1:3)$rotate(-1)$values()  # 2 3 1
}
\seealso{
\code{\link[container]{Container}}
}
\author{
Roman Pahl
}
\keyword{datasets}
