% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msplit.R
\name{conformal.fun.msplit}
\alias{conformal.fun.msplit}
\title{Functional Multi Split Conformal Prediction Regions}
\usage{
conformal.fun.msplit(
  x,
  t_x,
  y,
  t_y,
  x0,
  train.fun,
  predict.fun,
  alpha = 0.1,
  split = NULL,
  seed = FALSE,
  randomized = FALSE,
  seed.rand = FALSE,
  verbose = FALSE,
  rho = NULL,
  s.type = "alpha-max",
  B = 100,
  lambda = 0,
  tau = 0.05
)
}
\arguments{
\item{x}{The input variable, a list of n elements. Each element is composed by a list
of p vectors(with variable length, since the evaluation grid may change).
If x is NULL, the function will sample it from a gaussian.}

\item{t_x}{The grid points for the evaluation of function x. It is a list of vectors.
If the x data type is "fData" or "mfData" is must be NULL.}

\item{y}{The response variable. It is either, as with x, a list of list of
vectors or an fda object (of type fd, fData, mfData).}

\item{t_y}{The grid points for the evaluation of function y_val. It is a list of vectors.
If the y_val data type is "fData" or "mfData" is must be NULL.}

\item{x0}{The new points to evaluate, a list of n0 elements. Each element is composed
by a list of p vectors(with variable length).}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: list of features,
and y: list of responses.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}

\item{split}{Indices that define the data-split to be used (i.e., the indices
define the first half of the data-split, on which the model is trained).
Default is NULL, in which case the split is chosen randomly.}

\item{seed}{Integer to be passed to set.seed before defining the random
data-split to be used. Default is FALSE, which effectively sets no seed.
If both split and seed are passed, the former takes priority and the latter
is ignored.}

\item{randomized}{Should the randomized approach be used? Default is FALSE.}

\item{seed.rand}{The seed for the randomized version of the conformal.split.fun.
Default is FALSE.}

\item{verbose}{Should intermediate progress be printed out? Default is FALSE.}

\item{rho}{Vector containing the split proportion between
training and calibration set.
It has B components. Default is 0.5.}

\item{s.type}{The type of modulation function.
Currently we have 3 options: "identity","st-dev","alpha-max".}

\item{B}{Number of repetitions. Default is 100.}

\item{lambda}{Smoothing parameter. Default is 0.}

\item{tau}{It is a smoothing parameter:
tau=1-1/B  Bonferroni intersection method
tau=0 unadjusted intersection
Default is 0.05, a value selected through sensitivity analysis .}
}
\value{
A list containing lo, up, tn. lo and up are lists of length n0,
containing lists of length p, with vectors of lower and upper bounds.
tn is the list of the grid evaluations.
}
\description{
Compute prediction regions using functional multi split conformal inference.
}
\details{
The work is an extension of the univariate approach to Multi Split
conformal inference to a multivariate functional context, exploiting the concept of
depth measures.

This function is based on the package future.apply to
 perform parallelisation. If this package is not installed, then the function
 will abort.
}
\examples{
### SIMULATED DATA

#---------------------- Genero i dati
library(fda)
sample_size=100

xout <- seq(from=0,to=1,length.out=301)


nb <- 6
w=c(1,1,1)

set.seed(-1)
coeff <- matrix(rnorm(nb*length(w)),nb,length(w))
bsbasis_obj <- create.bspline.basis(rangeval=c(0,1),
                                    nbasis=nb, norder=4)
fd_obj <- fd(coeff, bsbasis_obj)
beta <- t(matrix(w,length(w),1)\%*\%rep(1,length(xout)))*eval.fd(xout, fd_obj)
beta_dim1=beta[,1:2]
beta_dim2=beta[,c(1,3)]

rm(coeff,bsbasis_obj,fd_obj,w,beta)


cov_dim1=array(NA,c(sample_size+1,length(xout),2))
cov_dim2=array(NA,c(sample_size+1,length(xout),2))

cov_dim1[,,1]=matrix(1,sample_size+1,length(xout))
cov_dim1[,,2]=matrix(rep(1:(sample_size+1)/(sample_size+1),length(xout)),
                     sample_size+1,length(xout))

cov_dim2[,,1]=matrix(1,sample_size+1,length(xout))
cov_dim2[,,2]=matrix(rep((1:(sample_size+1)/(sample_size+1))^2,length(xout)),
                     sample_size+1,length(xout))

deterministic_data_dim1=vapply(1:(sample_size+1),function(j)
  rowSums(beta_dim1*cov_dim1[j,,]),numeric(length(xout)))
deterministic_data_dim2=vapply(1:(sample_size+1),function(j)
  rowSums(beta_dim2*cov_dim2[j,,]),numeric(length(xout)))


w_error=rep(1,(sample_size+1)*2)
set.seed(1234)
coeff_error <- matrix(rnorm(nb*(sample_size+1)*2),nb,(sample_size+1)*2)
bsbasis_obj_error <- create.bspline.basis(rangeval=c(0,1),
                                          nbasis=nb, norder=4)
fd_obj_error <- fd(coeff_error, bsbasis_obj_error)
error_data <- t(matrix(w_error,length(w_error),1)
                \%*\%rep(1,length(xout)))*eval.fd(xout, fd_obj_error)

rm(coeff_error,bsbasis_obj_error,fd_obj_error,w_error)


data_dim1=deterministic_data_dim1+error_data[,1:(sample_size+1)]
data_dim2=deterministic_data_dim2+error_data[,(sample_size+2):(2*sample_size+2)]

rm(beta_dim1,beta_dim2,deterministic_data_dim1,deterministic_data_dim2,error_data,nb)

set.seed(1234)
obs_tbp=sample(1:(sample_size+1),1)

data_y=lapply(1:(sample_size+1),function(x) NULL)

for(i in 1:(sample_size+1)){
  data_y[[i]]=list(data_dim1[,i],data_dim2[,i])
}

new_data_y=list(data_y[[obs_tbp]])
data_y=data_y[-obs_tbp]

rm(data_dim1,data_dim2)

data_x=lapply(1:(sample_size+1),function(x) NULL)

for(i in 1:(sample_size+1)){
  data_x[[i]]=list(t(cov_dim1[i,,]),t(cov_dim2[i,,]))
}

new_x=list(data_x[[obs_tbp]])
data_x=data_x[-obs_tbp]

rm(obs_tbp,i,cov_dim1,cov_dim2)
#----------------------


n0=10
set.seed(1234)
len=length(data_x)
id=sample(1:len,n0)
n=len-n0
t=list(xout)
fun=mean_lists()
y0=data_y[id]
p<-length(y0[[1]])
grid_len<-length(y0[[1]][[1]])

### test multisplit depth

rrr<-conformal.fun.msplit(x=data_x[-id],t_x=NULL, y=data_y[-id],t_y=t, x0=data_x[id],
                          fun$train.fun, fun$predict.fun,alpha=0.5,
                           split=NULL, seed=FALSE, randomized=FALSE,seed.rand=FALSE,
                           verbose=FALSE, rho=NULL,B=100,lambda=0
)

mean(sapply(1:n0, function(i){
  for(j in 1:p){
    coverage=rep(1,grid_len)
    for(k in 1:grid_len){
      coverage[k]<-prod(c(coverage[k],as.numeric(rrr$lo[[i]][[j]][k]
                                                 <y0[[i]][[j]][[k]] && y0[[i]][[j]][[k]]
                                                 < rrr$up[[i]][[j]][k])))
    }
  }
  return(sum(coverage)/grid_len)

}))
}
\references{
"Multi Split Conformal Prediction" by Solari, Djordjilovic (2021) is
the baseline for the univariate case.
}
