% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor-functions.R
\name{locations}
\alias{locations}
\alias{locations.default}
\title{Extract Gradient Locations}
\usage{
locations(x, ...)

\method{locations}{default}(x, ...)
}
\arguments{
\item{x}{an object with \code{locations} as an attribute or a component, such as the object returned by \code{\link{coenocline}}.}

\item{...}{arguments passed to other methods.}
}
\value{
A vector or a matrix of gradient locations. For single-gradient simulations, a vector is returned, whereas for two-gradient simulations, a matrix of location pairs is returned.
}
\description{
Extract the gradient locations at which response curves were evaluated or for which counts were simulated.
}
\examples{

## Poisson counts along a single gradient, Gaussian response
## =========================================================

x <- seq(from = 4, to = 6, length = 100)
opt <- c(3.75, 4, 4.55, 5, 5.5) + 0.5
tol <- rep(0.25, 5)
h <- rep(20, 5)

## simulate
set.seed(1)
y <- coenocline(x, responseModel = "gaussian",
                params = cbind(opt = opt, tol = tol, h = h),
                countModel = "poisson")
head(locations(y))
}
\author{
Gavin L. Simpson
}
