% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{Cicerone}
\alias{Cicerone}
\title{Define Steps}
\description{
Define cicerone steps.
}
\section{Position}{

* left
* right
* left-center
* left-bottom
* top
* top-center
* top-right
* right
* right-center
* right-bottom
* bottom
* bottom-center
* mid-center
}

\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Cicerone$new()}}
\item \href{#method-step}{\code{Cicerone$step()}}
\item \href{#method-init}{\code{Cicerone$init()}}
\item \href{#method-reset}{\code{Cicerone$reset()}}
\item \href{#method-start}{\code{Cicerone$start()}}
\item \href{#method-move_forward}{\code{Cicerone$move_forward()}}
\item \href{#method-move_backward}{\code{Cicerone$move_backward()}}
\item \href{#method-highlight}{\code{Cicerone$highlight()}}
\item \href{#method-get_highlighted_el}{\code{Cicerone$get_highlighted_el()}}
\item \href{#method-get_previous_el}{\code{Cicerone$get_previous_el()}}
\item \href{#method-has_next_step}{\code{Cicerone$has_next_step()}}
\item \href{#method-clone}{\code{Cicerone$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$new(
  animate = TRUE,
  opacity = 0.75,
  padding = 10,
  allow_close = TRUE,
  overlay_click_next = FALSE,
  done_btn_text = "Done",
  close_btn_text = "Close",
  stage_background = "#ffffff",
  next_btn_text = "Next",
  prev_btn_text = "Previous",
  show_btns = TRUE,
  keyboard_control = TRUE,
  id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{animate}}{Whether to animate or not.}

\item{\code{opacity}}{Background opacity (0 means only popovers 
and without overlay).}

\item{\code{padding}}{Distance of element from around the edges.}

\item{\code{allow_close}}{Whether the click on overlay should close 
or not.}

\item{\code{overlay_click_next}}{Whether the click on overlay should 
move next.}

\item{\code{done_btn_text}}{Text on the final button.}

\item{\code{close_btn_text}}{Text on the close button for this step.}

\item{\code{stage_background}}{Background color for the staged behind 
highlighted element.}

\item{\code{next_btn_text}}{Next button text for this step.}

\item{\code{prev_btn_text}}{Previous button text for this step.}

\item{\code{show_btns}}{Do not show control buttons in footer.}

\item{\code{keyboard_control}}{Allow controlling through keyboard (escape 
to close, arrow keys to move).}

\item{\code{id}}{A unique identifier, useful if you are using more than one
cicerone.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new `Cicerone` object.
}

\subsection{Returns}{
A Cicerone object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-step"></a>}}
\subsection{Method \code{step()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$step(
  el,
  title = NULL,
  description = NULL,
  position = NULL,
  class = NULL,
  show_btns = NULL,
  close_btn_text = NULL,
  next_btn_text = NULL,
  prev_btn_text = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{el}}{Id of element to be highlighted.}

\item{\code{title}}{Title on the popover.}

\item{\code{description}}{Body of the popover.}

\item{\code{position}}{Where to position the popover. 
See positions section.}

\item{\code{class}}{className to wrap this specific step 
popover in addition to the general className in Driver 
options.}

\item{\code{show_btns}}{Whether to show control buttons.}

\item{\code{close_btn_text}}{Text on the close button.}

\item{\code{next_btn_text}}{Next button text.}

\item{\code{prev_btn_text}}{Previous button text.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Add a step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-init"></a>}}
\subsection{Method \code{init()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$init(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise Cicerone.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\subsection{Method \code{reset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$reset(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Reset Cicerone.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$start(step = 1, session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step}}{The step index at which to start.}

\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Start Cicerone.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-move_forward"></a>}}
\subsection{Method \code{move_forward()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$move_forward(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Move Cicerone one step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-move_backward"></a>}}
\subsection{Method \code{move_backward()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$move_backward(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Move Cicerone one step backward.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-highlight"></a>}}
\subsection{Method \code{highlight()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$highlight(el, session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{el}}{Id of element to highlight}

\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Highlight a specific step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_highlighted_el"></a>}}
\subsection{Method \code{get_highlighted_el()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$get_highlighted_el(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Retrieve the id of the currently highlighted element.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_previous_el"></a>}}
\subsection{Method \code{get_previous_el()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$get_previous_el(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Retrieve the id of the previously highlighted element.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_next_step"></a>}}
\subsection{Method \code{has_next_step()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$has_next_step(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session if \code{NULL} the function
attempts to get the session with \link[shiny]{getDefaultReactiveDomain}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Retrieve whether there is a next step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cicerone$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
