% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choroplethr_wdi.R
\name{choroplethr_wdi}
\alias{choroplethr_wdi}
\title{Create a country-level choropleth using data from the World Bank's World Development Indicators (WDI)}
\usage{
choroplethr_wdi(
  code = "SP.POP.TOTL",
  year = 2012,
  title = "",
  num_colors = 7,
  zoom = NULL
)
}
\arguments{
\item{code}{The WDI code to use.}

\item{year}{The year of data to use.}

\item{title}{A title for the map.  If not specified, automatically generated to include WDI code and year.}

\item{num_colors}{The number of colors to use on the map.  A value of 1 
will use a continuous scale, and a value in [2, 9] will use that many colors.}

\item{zoom}{An optional list of countries to zoom in on. Must come from the "name" column in
?country.regions.}
}
\value{
A choropleth.
}
\description{
Create a country-level choropleth using data from the World Bank's World Development Indicators (WDI)
}
\examples{
\donttest{
# See http://data.worldbank.org/indicator/SP.POP.TOTL
choroplethr_wdi(code="SP.POP.TOTL", year=2012, title="2012 Population Estimates", num_colors=1)

# See http://data.worldbank.org/indicator/SP.DYN.LE00.IN 
choroplethr_wdi(code="SP.DYN.LE00.IN", year=2012, title="2012 Life Expectancy Estimates")

# See http://data.worldbank.org/indicator/NY.GDP.PCAP.CD 
choroplethr_wdi(code="NY.GDP.PCAP.CD", year=2012, title="2012 Per Capita Income") 
}

}
\references{
Uses the WDI function from the WDI package by Vincent Arel-Bundock.
}
