% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracts.R
\name{tract_choropleth}
\alias{tract_choropleth}
\title{Create a choropleth of Census Tracts in a particular state.}
\usage{
tract_choropleth(df, state_name, title = "", legend = "", num_colors = 7,
  tract_zoom = NULL, county_zoom = NULL, reference_map = FALSE)
}
\arguments{
\item{df}{A data.frame with a column named "region" and a column named "value".}

\item{state_name}{The name of the state. See ?state.regions for proper spelling and capitalization.}

\item{title}{An optional title for the map.}

\item{legend}{An optional name for the legend.}

\item{num_colors}{The number of colors on the map. A value of 1 
will use a continuous scale. A value in [2, 9] will use that many colors.}

\item{tract_zoom}{An optional vector of tracts to zoom in on. Elements of this vector must exactly 
match the names of tracts as they appear in the "region" column of the object returned from "get_tract_map".}

\item{county_zoom}{An optional vector of county FIPS codes to zoom in on. Elements of this 
vector must exactly match the names of counties as they appear in the "county.fips.numeric" column 
of the object returned from "get_tract_map".}

\item{reference_map}{If true, render the choropleth over a reference map from Google Maps.}
}
\description{
Create a choropleth of Census Tracts in a particular state.
}
\seealso{
\url{https://www.census.gov/geo/reference/gtc/gtc_ct.html} for more information on Census Tracts
}
