#' A data.frame containing basic demographic information about Japan.  
#'
#' @name df_japan_census
#' @usage data(df_japan_census)
#' @docType data
#' @references Taken from the "Total Population" table from the Statistics Bureau of Japan website
#' (\url{http://www.stat.go.jp/english/data/nenkan/1431-02.htm}) on 12/1/2014.
#' @keywords data
NULL

#' A data.frame containing population estimates for Countries in 2012.   
#'
#' @name df_pop_country
#' @docType data
#' @references Taken from the WDI package with code SP.POP.TOTL for year 2012.
#' 
#' @keywords data
#' @usage data(df_pop_country)
NULL

#' A data.frame containing population estimates for US Counties in 2012.   
#'
#' @name df_pop_county
#' @docType data
#' @references Taken from the US American Community Survey (ACS) 5 year estimates.
#' 
#' @keywords data
#' @usage data(df_pop_county)
NULL

#' A data.frame containing election results from the 2012 US Presidential election.  
#'
#' @name df_president
#' @usage data(df_president)
#' @docType data
#' @references Taken from the FEC website on 11/21/2014.
#' @keywords data
#' @author Ari Lamstein and Richard Careaga
NULL

#' A data.frame containing population estimates for US States in 2012.   
#'
#' @name df_pop_state
#' @docType data
#' @references Taken from the US American Community Survey (ACS) 5 year estimates.
#' 
#' @keywords data
#' @usage data(df_pop_state)
NULL

#' A data.frame containing all US presdiential election results from 1789 to 2012
#' 
#' Legend: 
#' \itemize{
#'  \item R = Republican
#'  \item D = Democratic
#'  \item DR = Democratic-Republican
#'  \item W = Whig
#'  \item F = Federalist
#'  \item GW = George Washington
#'  \item NR = National Republican
#'  \item SD = Southern Democrat
#'  \item PR = Progressive
#'  \item AI = American Independent
#'  \item SR = States' Rights
#'  \item PO = Populist
#'  \item CU = Constitutional Union
#'  \item I = Independent
#'  \item ND = Northern Democrat
#'  \item KN = Know Nothing
#'  \item AM = Anti-Masonic
#'  \item N = Nullifier
#'  \item SP = Split evenly
#' }
#' @docType data
#' @references Taken from \url{http://en.wikipedia.org/wiki/List_of_United_States_presidential_election_results_by_state} 3/20/2014.
#' @keywords data
#' @name df_president_ts
#' @usage data(df_president_ts)
NULL

#' A data.frame containing demographic statistics for each state plus the District of Columbia.
#'
#' @name df_state_demographics
#' @docType data
#' @references Data comes from the 2013 5-year American Community Survey (ACS). Data generated by
#' ?get_state_demographics. 
#' @keywords data
#' @usage data(df_state_demographics)
#' @examples
#' \dontrun{
#' library(choroplethr)
#' data(df_state_demographics)
#' 
#' # examine the 2013, 5-year state percent hispanic estimates as a boxplot and choropleth
#'
#' # the boxplot shows the distribution
#' boxplot(df_state_demographics$percent_hispanic)
#' 
#' # the choropleth map shows the location of the values
#' # first set the 'value' column to be the column we want to render
#' df_state_demographics$value = df_state_demographics$percent_hispanic
#' state_choropleth(df_state_demographics)
#' }
NULL

#' A data.frame containing demographic statistics for each county in the United States.
#'
#' @name df_county_demographics
#' @docType data
#' @references Data comes from the 2013 5-year American Community Survey (ACS). Data generated by
#' ?get_county_demographics. 
#' @keywords data
#' @usage data(df_county_demographics)
#' @examples
#' \dontrun{
#' library(choroplethr)
#' data(df_county_demographics)
#' 
#' # examine the 2013, 5-year county percent hispanic estimates as a boxplot and choropleth
#'
#' # the boxplot shows the distribution
#' boxplot(df_county_demographics$percent_hispanic)
#' 
#' # the choropleth map shows the location of the values
#' # first set the 'value' column to be the column we want to render
#' df_county_demographics$value = df_county_demographics$percent_hispanic
#' county_choropleth(df_county_demographics)
#' }
NULL

#' A vector of the names of US Continental US States.
#'
#' @name continental_us_states
#' @usage data(continental_us_states)
#' @docType data
#' @keywords data
#' @author Ari Lamstein
NULL