% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowMap.R
\name{snowMap}
\alias{snowMap}
\title{Plot John Snow's cholera map.}
\usage{
snowMap(vestry = FALSE, stacked = TRUE, add.cases = TRUE,
  add.landmarks = FALSE, add.pumps = TRUE, add.roads = TRUE,
  add.frame = TRUE, main = NA, case.col = "gray", case.pch = 15,
  ...)
}
\arguments{
\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the map in the Vestry Report. \code{FALSE} uses the 13 pumps from the original map.}

\item{stacked}{Logical. Use stacked fatalities.}

\item{add.cases}{Logical. Add observed cases.}

\item{add.landmarks}{Logical. Add landmarks.}

\item{add.pumps}{Logical. Add pumps.}

\item{add.roads}{Logical. Add roads.}

\item{add.frame}{Logical. Add map frame.}

\item{main}{Character. Title of graph.}

\item{case.col}{Character. Color of fatalities.}

\item{case.pch}{Character. Color of fatalities.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R graphics plot.
}
\description{
Plot John Snow's cholera map.
}
\note{
Uses amended version of Dodson and Tobler's data included in this package.
}
\examples{
snowMap()
snowMap(vestry = TRUE, stacked = FALSE)
}
