% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cgraph}
\alias{cgraph}
\title{Computational Graph}
\description{
The \code{cgraph} class facilitates the construction, evaluation, and differentiation of computaiontal graphs in R.
}
\note{
Some of the methods listed above have a wrapper function that calls the method on the current active graph. For example, a parameter can be added to the current active graph by calling \link[cgraph]{parm} instead of calling \link[cgraph]{cg.parm} on the cgraph object.
}
\section{Usage}{

\preformatted{x <- cgraph$new()}
}

\section{Members}{

\describe{
\item{$nodes}{list, symbols of the nodes.}
\item{$values}{environment, values of the nodes.}
}
}

\section{Methods}{

\describe{
\item{$initialize}{initialize a computational graph, see \link[cgraph]{cg.initialize}.}
\item{$name}{generate a default name for a node, see \link[cgraph]{cg.name}.}
\item{$const}{add a constant node to the graph, see \link[cgraph]{cg.const}.}
\item{$input}{add an input node to the graph, see \link[cgraph]{cg.input}.}
\item{$parm}{add a parameter node to the graph, see \link[cgraph]{cg.parm}.}
\item{$get.parms}{list all parameters and their values, see \link[cgraph]{cg.get.parms}.}
\item{$add.parms}{add parameters to the graph, see \link[cgraph]{cg.add.parms}.}
\item{$opr}{add an operation node to the graph, see \link[cgraph]{cg.opr}.}
\item{$active}{set the graph to be the active graph, see \link[cgraph]{cg.active}.}
\item{$run}{evaluate a node in the graph, see \link[cgraph]{cg.run}.}
\item{$gradients}{differentiate the graph by reverse automatic differentiation, see \link[cgraph]{cg.gradients}.}
\item{$approx.grad}{differentiate the graph by numerical differentiation, see \link[cgraph]{cg.approx.grad}.}
\item{$adj.mat}{retrieve the adjacency matrix of the graph, see \link[cgraph]{cg.adj.mat}.}
\item{$plot}{plot the topology of the graph, see \link[cgraph]{cg.plot}.}
}
}

\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add some parameters.
a <- parm(2, name = "a")
b <- parm(4, name = "b")

# Perform some operations on the parameters.
c <- sin(a) + cos(b) - tan(a) + tanh(b)

# Evaluate c.
values <- run(c)

# Retrieve the value of c (the node is called 'opr7' in the graph).
values$opr7

# Differentiate the graph with respect to c.
grads <- gradients(c, values)

# Retrieve the gradient of c with respect to a.
grads$a

}
\author{
Ron Triepels
}
