% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{cmicroRNA}
\alias{cmicroRNA}
\title{Construct cmicroRNA object}
\usage{
cmicroRNA(dat_mir)
}
\arguments{
\item{dat_mir}{A \code{data.frame} such as this returned by calling
\link{get_mir}.}
}
\value{
An S3 object of class \code{cmicroRNA}
}
\description{
Constructs an S3 object called cmicroRNA contains data returned by calling
\link{get_mir}. Used to define methods for printing and visualizing
microRNA-gene expression correlations.
}
\examples{
# load required libraries
library(RSQLite)
library(cRegulome)

# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- dbConnect(SQLite(), fl)

# enter a custom query with different arguments
dat <- get_mir(conn,
               mir = 'hsa-let-7g',
               study = 'STES',
               min_abs_cor = .3,
               max_num = 5)

# make a cmicroRNA object   
cmir <- cmicroRNA(dat)

}
