% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_plus_plus.R
\name{tidy_plus_plus}
\alias{tidy_plus_plus}
\title{Tidy a model and compute additional informations}
\usage{
tidy_plus_plus(
  model,
  tidy_fun = tidy_with_broom_or_parameters,
  conf.int = TRUE,
  conf.level = 0.95,
  exponentiate = FALSE,
  model_matrix_attr = TRUE,
  variable_labels = NULL,
  instrumental_suffix = " (instrumental)",
  term_labels = NULL,
  interaction_sep = " * ",
  categorical_terms_pattern = "{level}",
  disambiguate_terms = TRUE,
  disambiguate_sep = ".",
  add_reference_rows = TRUE,
  no_reference_row = NULL,
  add_pairwise_contrasts = FALSE,
  pairwise_variables = all_categorical(),
  keep_model_terms = FALSE,
  pairwise_reverse = TRUE,
  contrasts_adjust = NULL,
  emmeans_args = list(),
  add_estimate_to_reference_rows = TRUE,
  add_header_rows = FALSE,
  show_single_row = NULL,
  add_n = TRUE,
  intercept = FALSE,
  include = everything(),
  keep_model = FALSE,
  tidy_post_fun = NULL,
  quiet = FALSE,
  strict = FALSE,
  ...
)
}
\arguments{
\item{model}{(a model object, e.g. \code{glm})\cr
A model to be attached/tidied.}

\item{tidy_fun}{(\code{function})\cr
Option to specify a custom tidier function.}

\item{conf.int}{(\code{logical})\cr
Should confidence intervals be computed? (see \code{\link[broom:reexports]{broom::tidy()}})}

\item{conf.level}{(\code{numeric})\cr
Level of confidence for confidence intervals (default: 95\%).}

\item{exponentiate}{(\code{logical})\cr
Whether or not to exponentiate the coefficient estimates.
This is typical for logistic, Poisson and Cox models,
but a bad idea if there is no log or logit link; defaults to \code{FALSE}.}

\item{model_matrix_attr}{(\code{logical})\cr
Whether model frame and model matrix should be added as attributes of \code{model}
(respectively named \code{"model_frame"} and \code{"model_matrix"}) and passed through.}

\item{variable_labels}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
A named list or a named vector of custom variable labels.}

\item{instrumental_suffix}{(\code{string})\cr
Suffix added to variable labels for instrumental variables (\code{fixest} models).
\code{NULL} to add nothing.}

\item{term_labels}{(\code{list} or \code{vector})\cr
A named list or a named vector of custom term labels.}

\item{interaction_sep}{(\code{string})\cr
Separator for interaction terms.}

\item{categorical_terms_pattern}{(\code{\link[glue:glue]{glue pattern}})\cr
A \link[glue:glue]{glue pattern} for labels of categorical terms with treatment
or sum contrasts (see \code{\link[=model_list_terms_levels]{model_list_terms_levels()}}).}

\item{disambiguate_terms}{(\code{logical})\cr
Should terms be disambiguated with
\code{\link[=tidy_disambiguate_terms]{tidy_disambiguate_terms()}}? (default \code{TRUE})}

\item{disambiguate_sep}{(\code{string})\cr
Separator for \code{\link[=tidy_disambiguate_terms]{tidy_disambiguate_terms()}}.}

\item{add_reference_rows}{(\code{logical})\cr
Should reference rows be added?}

\item{no_reference_row}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables for those no reference row should be added,
when \code{add_reference_rows = TRUE}.}

\item{add_pairwise_contrasts}{(\code{logical})\cr
Apply \code{\link[=tidy_add_pairwise_contrasts]{tidy_add_pairwise_contrasts()}}?}

\item{pairwise_variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to add pairwise contrasts.}

\item{keep_model_terms}{(\code{logical})\cr
Keep original model terms for variables where
pairwise contrasts are added? (default is \code{FALSE})}

\item{pairwise_reverse}{(\code{logical})\cr
Determines whether to use \code{"pairwise"} (if \code{TRUE})
or \code{"revpairwise"} (if \code{FALSE}), see \code{\link[emmeans:contrast]{emmeans::contrast()}}.}

\item{contrasts_adjust}{(\code{string})\cr
Optional adjustment method when computing contrasts,
see \code{\link[emmeans:contrast]{emmeans::contrast()}} (if \code{NULL}, use \code{emmeans} default).}

\item{emmeans_args}{(\code{list})\cr
List of additional parameter to pass to
\code{\link[emmeans:emmeans]{emmeans::emmeans()}} when computing pairwise contrasts.}

\item{add_estimate_to_reference_rows}{(\code{logical})\cr
Should an estimate value be added to reference rows?}

\item{add_header_rows}{(\code{logical})\cr
Should header rows be added?}

\item{show_single_row}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables that should be displayed on a single row,
when \code{add_header_rows} is \code{TRUE}.}

\item{add_n}{(\code{logical})\cr
Should the number of observations be added?}

\item{intercept}{(\code{logical})\cr
Should the intercept(s) be included?}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include. Default is \code{everything()}.
See also \code{\link[=all_continuous]{all_continuous()}}, \code{\link[=all_categorical]{all_categorical()}}, \code{\link[=all_dichotomous]{all_dichotomous()}}
and \code{\link[=all_interaction]{all_interaction()}}.}

\item{keep_model}{(\code{logical})\cr
Should the model be kept as an attribute of the final result?}

\item{tidy_post_fun}{(\code{function})\cr
Custom function applied to the results at the end of
\code{tidy_plus_plus()} (see note)}

\item{quiet}{(\code{logical})\cr
Whether \code{broom.helpers} should not return a message when requested output
cannot be generated. Default is \code{FALSE}.}

\item{strict}{(\code{logical})\cr
Whether \code{broom.helpers} should return an error
when requested output cannot be generated. Default is \code{FALSE}.}

\item{...}{other arguments passed to \code{tidy_fun()}}
}
\description{
This function will apply sequentially:
\itemize{
\item \code{\link[=tidy_and_attach]{tidy_and_attach()}}
\item \code{\link[=tidy_disambiguate_terms]{tidy_disambiguate_terms()}}
\item \code{\link[=tidy_identify_variables]{tidy_identify_variables()}}
\item \code{\link[=tidy_add_contrasts]{tidy_add_contrasts()}}
\item \code{\link[=tidy_add_reference_rows]{tidy_add_reference_rows()}}
\item \code{\link[=tidy_add_pairwise_contrasts]{tidy_add_pairwise_contrasts()}}
\item \code{\link[=tidy_add_estimate_to_reference_rows]{tidy_add_estimate_to_reference_rows()}}
\item \code{\link[=tidy_add_variable_labels]{tidy_add_variable_labels()}}
\item \code{\link[=tidy_add_term_labels]{tidy_add_term_labels()}}
\item \code{\link[=tidy_add_header_rows]{tidy_add_header_rows()}}
\item \code{\link[=tidy_add_n]{tidy_add_n()}}
\item \code{\link[=tidy_remove_intercept]{tidy_remove_intercept()}}
\item \code{\link[=tidy_select_variables]{tidy_select_variables()}}
\item \code{\link[=tidy_add_coefficients_type]{tidy_add_coefficients_type()}}
\item \code{\link[=tidy_detach_model]{tidy_detach_model()}}
}
}
\note{
\code{tidy_post_fun} is applied to the result at the end of \code{tidy_plus_plus()}
and receive only one argument (the result of \code{tidy_plus_plus()}). However,
if needed, the model is still attached to the tibble as an attribute, even
if \code{keep_model = FALSE}. Therefore, it is possible to use \code{\link[=tidy_get_model]{tidy_get_model()}}
within \code{tidy_fun} if, for any reason, you need to access the source model.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ex1 <- lm(Sepal.Length ~ Sepal.Width + Species, data = iris) |>
  tidy_plus_plus()
ex1

df <- Titanic |>
  dplyr::as_tibble() |>
  dplyr::mutate(
    Survived = factor(Survived, c("No", "Yes"))
  ) |>
  labelled::set_variable_labels(
    Class = "Passenger's class",
    Sex = "Gender"
  )
ex2 <- glm(
  Survived ~ Class + Age * Sex,
  data = df, weights = df$n,
  family = binomial
) |>
  tidy_plus_plus(
    exponentiate = TRUE,
    add_reference_rows = FALSE,
    categorical_terms_pattern = "{level} / {reference_level}",
    add_n = TRUE
  )
ex2
if (.assert_package("gtsummary", boolean = TRUE)) {
  ex3 <-
    glm(
      response ~ poly(age, 3) + stage + grade * trt,
      na.omit(gtsummary::trial),
      family = binomial,
      contrasts = list(
        stage = contr.treatment(4, base = 3),
        grade = contr.sum
      )
    ) |>
    tidy_plus_plus(
      exponentiate = TRUE,
      variable_labels = c(age = "Age (in years)"),
      add_header_rows = TRUE,
      show_single_row = all_dichotomous(),
      term_labels = c("poly(age, 3)3" = "Cubic age"),
      keep_model = TRUE
    )
  ex3
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
