% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_model_matrix.R
\name{model_get_model_matrix}
\alias{model_get_model_matrix}
\alias{model_get_model_matrix.default}
\alias{model_get_model_matrix.multinom}
\alias{model_get_model_matrix.clm}
\title{Get the model matrix of a model}
\usage{
model_get_model_matrix(model)

\method{model_get_model_matrix}{default}(model)

\method{model_get_model_matrix}{multinom}(model)

\method{model_get_model_matrix}{clm}(model)
}
\arguments{
\item{model}{a model object}
}
\description{
The structure of the object returned by \code{\link[stats:model.matrix]{stats::model.matrix()}}
could slightly differ for certain types of models.
\code{model_get_model_matrix()} will always return an object
with the same structure as \code{\link[stats:model.matrix]{stats::model.matrix.default()}}.
}
\examples{
lm(hp ~ mpg + factor(cyl), mtcars) \%>\%
  model_get_model_matrix() \%>\%
  head()
}
\seealso{
\code{\link[stats:model.matrix]{stats::model.matrix()}}

Other model_helpers: 
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
