% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breathtest_parameters.R
\name{t50_maes_ghoos}
\alias{t50_maes_ghoos}
\title{Half-emptying time by Maes/Ghoos method}
\usage{
t50_maes_ghoos(cf)
}
\arguments{
\item{cf}{named vector of coefficients; only \code{k} and \code{beta} are required
note that \code{k} is measured in 1/min (e.g. 0.01/min),
usually it is quoted as 1/h (e.g. 0.6/h).}
}
\value{
Time where value is 1/2 of maximum, i.e. \code{t50} in minutes
}
\description{
Half-emptying time t50 as determined from an uncorrected fit to 
the beta exponential function.

Maes B D, Ghoos Y F, Rutgeerts P J, Hiele M I, Geypens B and Vantrappen G 1994 
Dig. Dis. Sci. 39 S104-6.
}
\seealso{
\code{\link{exp_beta}}, and \code{\link{t50_bluck_coward}} for an example.
}
