% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_tables.R
\name{bp_tables}
\alias{bp_tables}
\title{Blood Pressure Tables}
\usage{
bp_tables(
  data,
  bp_type = c("both", "sbp", "dbp"),
  bp_perc_margin = NULL,
  wake_perc_margin = 2,
  subj = NULL
)
}
\arguments{
\item{data}{A processed dataframe resulting from the \code{process_data} function that
contains the \code{SBP}, \code{DBP}, \code{DAY_OF_WEEK}, \code{Time_of_Day}, \code{SBP_CATEGORY},
and \code{DBP_CATEGORY} columns.}

\item{bp_type}{Optional argument. Determines whether to calculate tables for SBP
values or DBP values, or both. For \strong{both SBP and DBP} ARV values use bp_type = 'both',
for \strong{SBP-only} use bp_type = 'sbp, and for \strong{DBP-only} use bp_type = 'dbp'.
If no type specified, default will be set to 'both'}

\item{bp_perc_margin}{An optional argument that determines which of the marginal totals
to include in the raw count tables expressed as percentages. The argument can take on
values either NULL (default, both SBP and DBP), 1 (SBP only), or 2 (DBP only).}

\item{wake_perc_margin}{An optional argument that determines which of the marginal totals
to include in the tables pertaining to the percentages of awake / asleep readings if
applicable (i.e. if the WAKE column is present). The argument can take on values either
NULL (both SBP and DBP), 1 (SBP only), or 2 (DBP only).}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}
}
\value{
A list of table outputs for various subsets of the data based on which bp_type is selected
}
\description{
Generate a list of pertinent table outputs that detail various information
specific to blood pressure.
}
\examples{
data("bp_jhs")
data("bp_hypnos")
hyp_proc <- process_data(bp_hypnos,
                         bp_type = 'abpm',
                         sbp = "syst",
                         dbp = "DIAST",
                         date_time = "date.time",
                         id = "id",
                         wake = "wake",
                         visit = "visit",
                         hr = "hr",
                         map = "map",
                         rpp = "rpp",
                         pp = "pp",
                         ToD_int = c(5, 13, 18, 23))

jhs_proc <- process_data(bp_jhs,
                         sbp = "Sys.mmHg.",
                         dbp = "Dias.mmHg.",
                         date_time = "DateTime",
                         hr = "pulse.bpm.")
rm(bp_hypnos, bp_jhs)

bp_tables(jhs_proc)
bp_tables(hyp_proc)

}
