% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genhol.R
\name{genhol}
\alias{genhol}
\title{Generate Holiday Regression Variables}
\usage{
genhol(dates, holiday.dates, start = 7, end = 7)
}
\arguments{
\item{dates}{a vector of class "Date", containing the data dates}

\item{holiday.dates}{a vector of class "Date", containing the occurrences of the holiday. It can be generated with as.Date().}

\item{start}{integer, shifts backwards the start point of the holiday. Use negative values if start is after the specified date.}

\item{end}{integer, shifts end point of the holiday. Use negative values if end is before the specified date.}
}
\value{
a matrix with holiday variables that can be used as a user defined variable in boiwsa().
}
\description{
Can be used to generate moving holiday regressors for the U. S. holidays of Easter,
Labor Day, and Thanksgiving; or for Israeli Rosh Hashanah and Pesach. The variables are computed
using the Easter formula in Table 2 of Findley et al. (1998). Uses calendar centring to avoid bias.
}
\examples{

# Creating moving holiday variable for Israeli Rosh Hashanah
data(gasoline.data)
data(holiday_dates_il) # dates of Israeli Rosh Hashanah and Pesach
movehol=genhol(gasoline.data$date,holiday.dates = holiday_dates_il$rosh)


}
\references{
Findley, D.F., Monsell, B.C., Bell, W.R., Otto, M.C. and B.C Chen (1998). New capabilities and methods of the X-12-ARIMA seasonal-adjustment program. Journal of Business & Economic Statistics, 16(2), pp.127-152.
}
