% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{html_page}
\alias{html_page}
\title{An R Markdown output format for \pkg{blogdown} web pages}
\usage{
html_page(..., number_sections = FALSE, self_contained = FALSE, highlight = NULL, 
    template = NULL, pre_knit = NULL, post_processor = NULL)
}
\arguments{
\item{..., number_sections, self_contained, highlight, template}{Arguments passed
to \code{bookdown::html_document2()} (note the option \code{theme} is not
supported and set to \code{NULL} internally, and when \code{template =
NULL}, a default template in \pkg{blogdown} will be used).}

\item{pre_knit, post_processor}{Passed to
\code{rmarkdown::\link{output_format}}.}
}
\description{
This function is a simple wrapper of \code{bookdown::\link{html_document2}()}
with different default arguments, and more importantly, a special HTML
template designed only for \pkg{blogdown} to render R Markdown to HTML pages
that can be processed by Hugo.
}
\details{
The HTML output is not a complete HTML document, and only meaningful to
\pkg{blogdown} (it will be post-processed to render valid HTML pages). The
only purpose of this output format is for users to change options in YAML.

The fact that it is based on \pkg{bookdown} means most \pkg{bookdown}
features are supported, such as numbering and cross-referencing
figures/tables.
}
\note{
Do not use a custom template unless you understand how the default
  template actually works (see the \pkg{blogdown} book).

  The argument \code{highlight} does not support the value \code{"textmate"},
  and the argument \code{template} does not support the value
  \code{"default"}.
}
\references{
See Chapter 2 of the \pkg{bookdown} book for the Markdown syntax:
  \url{https://bookdown.org/yihui/bookdown}. See the \pkg{blogdown} book for
  full details: \url{https://bookdown.org/yihui/blogdown}.
}
