% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inference_model_filenames.R
\name{get_inference_model_filenames}
\alias{get_inference_model_filenames}
\title{Get the filenames stored in an inference model.}
\usage{
get_inference_model_filenames(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\description{
If there is no name for a \code{tipdates} file specified (as done by
setting \code{inference_model$tipdates_filename} to \link{NA},
there will be one filename less returned
}
\examples{
inference_model <- create_inference_model()
filenames <- get_inference_model_filenames(inference_model)
}
