% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_param_name.R
\name{is_param_name}
\alias{is_param_name}
\title{Determines if the name is a valid parameter name}
\usage{
is_param_name(name)
}
\arguments{
\item{name}{the name to be tested}
}
\value{
TRUE if the name is a valid parameter name, FALSE otherwise
}
\description{
Determines if the name is a valid parameter name
}
\examples{
library(testthat)

expect_true(is_param_name("alpha"))
expect_true(is_param_name("beta"))
expect_true(is_param_name("clock_rate"))
expect_true(is_param_name("kappa_1"))
expect_true(is_param_name("kappa_2"))
expect_true(is_param_name("lambda"))
expect_true(is_param_name("m"))
expect_true(is_param_name("mean"))
expect_true(is_param_name("mu"))
expect_true(is_param_name("rate_ac"))
expect_true(is_param_name("rate_ag"))
expect_true(is_param_name("rate_at"))
expect_true(is_param_name("rate_cg"))
expect_true(is_param_name("rate_ct"))
expect_true(is_param_name("rate_gt"))
expect_true(is_param_name("s"))
expect_true(is_param_name("scale"))
expect_true(is_param_name("sigma"))

expect_false(is_param_name("nonsense"))
expect_false(is_param_name(NA))
expect_false(is_param_name(NULL))
expect_false(is_param_name(""))
expect_false(is_param_name(c()))
}
\author{
Richèl J.C. Bilderbeek
}
