% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_param.R
\name{check_param}
\alias{check_param}
\title{Check if the parameter is a valid parameter}
\usage{
check_param(param)
}
\arguments{
\item{param}{a parameter, as can be created by \code{\link{create_param}}.}
}
\value{
nothing
}
\description{
Calls \code{stop} if the parameter is invalid
}
\examples{
library(testthat)

expect_silent(check_param(create_alpha_param()))
expect_silent(check_param(create_beta_param()))

# List of two parameters is not a/one parameter
expect_error(
   check_param(
     list(create_alpha_param(), create_beta_param())
   )
 )

# Must stop on non-parameters
expect_error(check_param("nonsense"))
expect_error(check_param(NULL))
expect_error(check_param(NA))
expect_error(check_param(""))
expect_error(check_param(c()))
}
\seealso{
Use \link{create_param} to create a valid parameter
}
\author{
Richèl J.C. Bilderbeek
}
