#' Creates the \code{init} section of a BEAST2 XML parameter file
#' @inheritParams default_params_doc
#' @return lines of XML text
#' @author Richèl J.C. Bilderbeek
#' @noRd
create_beast2_input_init <- function(
  ids,
  initial_phylogenies
) {
  testit::assert(are_initial_phylogenies(initial_phylogenies)) # nolint beautier function
  testit::assert(are_ids(ids)) # nolint beautier function
  testit::assert(length(ids) == length(initial_phylogenies))

  text <- NULL

  # From https://www.beast2.org/fix-starting-tree/:
  #
  # if there is an initaliser generated by BEAUti of the form
  #
  #   <init estimate="false" id="RandomTree.t:xxx" initial="@Tree.t:xxx"
  #     spec="beast.evolution.tree.RandomTree" taxa="@xxx">
  #   </init>
  #
  # remove this element from the file, otherwise the tree will be Newick tree
  #   will be overwritten by a random tree.
  #
  # In other words: bluntly remove it
  n <- length(ids)
  for (i in seq(1, n)) {
    phylogeny <- initial_phylogenies[[i]]
    id <- ids[i]
    if (!is_phylo(phylogeny)) { # nolint beautier function
      text <- c(text, "")
      text <- c(
        text,
        indent(rnd_phylo_to_xml_init(id), n_spaces = 4) # nolint beautier function
      )
    }
  }
  text
}
