// Generated by rstantools.  Do not edit by hand.

/*
    Bforecast is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Bforecast is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Bforecast.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_tgarch_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_tgarch");
    reader.add_event(271, 269, "end", "model_tgarch");
    return reader;
}
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
Jpv(const T0__& v, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        current_statement_begin__ = 4;
        stan::math::assign(y, ((trigamma((v / 2)) - trigamma(((v + 1) / 2))) - ((2 * (v + 3)) / ((v * (v + 1)) * (v + 1)))));
        current_statement_begin__ = 5;
        stan::math::assign(y, ((v / (v + 3)) * y));
        current_statement_begin__ = 6;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::sqrt(y));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct Jpv_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& v, std::ostream* pstream__) const {
        return Jpv(v, pstream__);
    }
};
template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
asymf(const T0__& u,
          const T1__& gamma,
          const int& asym, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 9;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        current_statement_begin__ = 10;
        if (as_bool(logical_eq(asym, 0))) {
            current_statement_begin__ = 10;
            stan::math::assign(y, u);
        }
        current_statement_begin__ = 11;
        if (as_bool(logical_eq(asym, 1))) {
            current_statement_begin__ = 11;
            stan::math::assign(y, inv_logit((-(gamma) * u)));
        }
        current_statement_begin__ = 12;
        if (as_bool(logical_eq(asym, 2))) {
            current_statement_begin__ = 12;
            stan::math::assign(y, (1 - stan::math::exp((-(gamma) * pow(u, 2)))));
        }
        current_statement_begin__ = 13;
        return stan::math::promote_scalar<fun_return_scalar_t__>((pow(u, 2) * y));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct asymf_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& u,
          const T1__& gamma,
          const int& asym, std::ostream* pstream__) const {
        return asymf(u, gamma, asym, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_tgarch
  : public stan::model::model_base_crtp<model_tgarch> {
private:
        int n;
        int s;
        int k;
        int h;
        int p;
        int q;
        vector_d y;
        int genT;
        int d1;
        matrix_d xreg;
        vector_d prior_mu0;
        vector_d prior_sigma0;
        vector_d prior_dfv;
        matrix_d prior_ar;
        matrix_d prior_ma;
        matrix_d prior_arch;
        matrix_d prior_garch;
        matrix_d prior_mgarch;
        matrix_d prior_breg;
        int asym;
        int asym1;
        matrix_d prior_gamma;
public:
    model_tgarch(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_tgarch(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_tgarch_namespace::model_tgarch";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "s", "int", context__.to_vec());
            s = int(0);
            vals_i__ = context__.vals_i("s");
            pos__ = 0;
            s = vals_i__[pos__++];
            check_greater_or_equal(function__, "s", s, 0);
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "h", "int", context__.to_vec());
            h = int(0);
            vals_i__ = context__.vals_i("h");
            pos__ = 0;
            h = vals_i__[pos__++];
            check_greater_or_equal(function__, "h", h, 0);
            current_statement_begin__ = 22;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 0);
            current_statement_begin__ = 24;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "genT", "int", context__.to_vec());
            genT = int(0);
            vals_i__ = context__.vals_i("genT");
            pos__ = 0;
            genT = vals_i__[pos__++];
            check_greater_or_equal(function__, "genT", genT, 0);
            check_less_or_equal(function__, "genT", genT, 1);
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "d1", "int", context__.to_vec());
            d1 = int(0);
            vals_i__ = context__.vals_i("d1");
            pos__ = 0;
            d1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "d1", d1, 0);
            current_statement_begin__ = 27;
            validate_non_negative_index("xreg", "n", n);
            validate_non_negative_index("xreg", "d1", d1);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(n,d1));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, d1);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = d1;
            size_t xreg_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 29;
            validate_non_negative_index("prior_mu0", "4", 4);
            context__.validate_dims("data initialization", "prior_mu0", "vector_d", context__.to_vec(4));
            prior_mu0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_mu0");
            pos__ = 0;
            size_t prior_mu0_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_mu0_j_1_max__; ++j_1__) {
                prior_mu0(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 30;
            validate_non_negative_index("prior_sigma0", "4", 4);
            context__.validate_dims("data initialization", "prior_sigma0", "vector_d", context__.to_vec(4));
            prior_sigma0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_sigma0");
            pos__ = 0;
            size_t prior_sigma0_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_sigma0_j_1_max__; ++j_1__) {
                prior_sigma0(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 31;
            validate_non_negative_index("prior_dfv", "4", 4);
            context__.validate_dims("data initialization", "prior_dfv", "vector_d", context__.to_vec(4));
            prior_dfv = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_dfv");
            pos__ = 0;
            size_t prior_dfv_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_dfv_j_1_max__; ++j_1__) {
                prior_dfv(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 32;
            validate_non_negative_index("prior_ar", "p", p);
            validate_non_negative_index("prior_ar", "4", 4);
            context__.validate_dims("data initialization", "prior_ar", "matrix_d", context__.to_vec(p,4));
            prior_ar = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(p, 4);
            vals_r__ = context__.vals_r("prior_ar");
            pos__ = 0;
            size_t prior_ar_j_2_max__ = 4;
            size_t prior_ar_j_1_max__ = p;
            for (size_t j_2__ = 0; j_2__ < prior_ar_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ar_j_1_max__; ++j_1__) {
                    prior_ar(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 33;
            validate_non_negative_index("prior_ma", "q", q);
            validate_non_negative_index("prior_ma", "4", 4);
            context__.validate_dims("data initialization", "prior_ma", "matrix_d", context__.to_vec(q,4));
            prior_ma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(q, 4);
            vals_r__ = context__.vals_r("prior_ma");
            pos__ = 0;
            size_t prior_ma_j_2_max__ = 4;
            size_t prior_ma_j_1_max__ = q;
            for (size_t j_2__ = 0; j_2__ < prior_ma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ma_j_1_max__; ++j_1__) {
                    prior_ma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 34;
            validate_non_negative_index("prior_arch", "s", s);
            validate_non_negative_index("prior_arch", "4", 4);
            context__.validate_dims("data initialization", "prior_arch", "matrix_d", context__.to_vec(s,4));
            prior_arch = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(s, 4);
            vals_r__ = context__.vals_r("prior_arch");
            pos__ = 0;
            size_t prior_arch_j_2_max__ = 4;
            size_t prior_arch_j_1_max__ = s;
            for (size_t j_2__ = 0; j_2__ < prior_arch_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_arch_j_1_max__; ++j_1__) {
                    prior_arch(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 35;
            validate_non_negative_index("prior_garch", "k", k);
            validate_non_negative_index("prior_garch", "4", 4);
            context__.validate_dims("data initialization", "prior_garch", "matrix_d", context__.to_vec(k,4));
            prior_garch = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, 4);
            vals_r__ = context__.vals_r("prior_garch");
            pos__ = 0;
            size_t prior_garch_j_2_max__ = 4;
            size_t prior_garch_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < prior_garch_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_garch_j_1_max__; ++j_1__) {
                    prior_garch(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("prior_mgarch", "h", h);
            validate_non_negative_index("prior_mgarch", "4", 4);
            context__.validate_dims("data initialization", "prior_mgarch", "matrix_d", context__.to_vec(h,4));
            prior_mgarch = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(h, 4);
            vals_r__ = context__.vals_r("prior_mgarch");
            pos__ = 0;
            size_t prior_mgarch_j_2_max__ = 4;
            size_t prior_mgarch_j_1_max__ = h;
            for (size_t j_2__ = 0; j_2__ < prior_mgarch_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_mgarch_j_1_max__; ++j_1__) {
                    prior_mgarch(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 37;
            validate_non_negative_index("prior_breg", "d1", d1);
            validate_non_negative_index("prior_breg", "4", 4);
            context__.validate_dims("data initialization", "prior_breg", "matrix_d", context__.to_vec(d1,4));
            prior_breg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(d1, 4);
            vals_r__ = context__.vals_r("prior_breg");
            pos__ = 0;
            size_t prior_breg_j_2_max__ = 4;
            size_t prior_breg_j_1_max__ = d1;
            for (size_t j_2__ = 0; j_2__ < prior_breg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_breg_j_1_max__; ++j_1__) {
                    prior_breg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "asym", "int", context__.to_vec());
            asym = int(0);
            vals_i__ = context__.vals_i("asym");
            pos__ = 0;
            asym = vals_i__[pos__++];
            check_greater_or_equal(function__, "asym", asym, 0);
            check_less_or_equal(function__, "asym", asym, 2);
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "asym1", "int", context__.to_vec());
            asym1 = int(0);
            vals_i__ = context__.vals_i("asym1");
            pos__ = 0;
            asym1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "asym1", asym1, 0);
            check_less_or_equal(function__, "asym1", asym1, 1);
            current_statement_begin__ = 42;
            validate_non_negative_index("prior_gamma", "(asym1 * 2)", (asym1 * 2));
            validate_non_negative_index("prior_gamma", "4", 4);
            context__.validate_dims("data initialization", "prior_gamma", "matrix_d", context__.to_vec((asym1 * 2),4));
            prior_gamma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((asym1 * 2), 4);
            vals_r__ = context__.vals_r("prior_gamma");
            pos__ = 0;
            size_t prior_gamma_j_2_max__ = 4;
            size_t prior_gamma_j_1_max__ = (asym1 * 2);
            for (size_t j_2__ = 0; j_2__ < prior_gamma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_gamma_j_1_max__; ++j_1__) {
                    prior_gamma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 46;
            num_params_r__ += 1;
            current_statement_begin__ = 47;
            num_params_r__ += 1;
            current_statement_begin__ = 48;
            validate_non_negative_index("breg", "d1", d1);
            num_params_r__ += d1;
            current_statement_begin__ = 49;
            validate_non_negative_index("ar0", "p", p);
            num_params_r__ += p;
            current_statement_begin__ = 50;
            validate_non_negative_index("ma0", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 51;
            validate_non_negative_index("arch", "s", s);
            num_params_r__ += s;
            current_statement_begin__ = 52;
            validate_non_negative_index("garch", "k", k);
            num_params_r__ += k;
            current_statement_begin__ = 53;
            validate_non_negative_index("mgarch", "h", h);
            num_params_r__ += h;
            current_statement_begin__ = 54;
            validate_non_negative_index("v", "(genT * 1)", (genT * 1));
            num_params_r__ += (genT * 1);
            current_statement_begin__ = 55;
            validate_non_negative_index("lambda", "(genT * n)", (genT * n));
            num_params_r__ += (genT * n);
            current_statement_begin__ = 56;
            validate_non_negative_index("gamma", "(asym1 * 2)", (asym1 * 2));
            num_params_r__ += (asym1 * 2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_tgarch() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 46;
        if (!(context__.contains_r("mu0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu0", "double", context__.to_vec());
        double mu0(0);
        mu0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 47;
        if (!(context__.contains_r("sigma0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma0", "double", context__.to_vec());
        double sigma0(0);
        sigma0 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 48;
        if (!(context__.contains_r("breg")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable breg missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("breg");
        pos__ = 0U;
        validate_non_negative_index("breg", "d1", d1);
        context__.validate_dims("parameter initialization", "breg", "vector_d", context__.to_vec(d1));
        Eigen::Matrix<double, Eigen::Dynamic, 1> breg(d1);
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            breg(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(breg);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable breg: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 49;
        if (!(context__.contains_r("ar0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ar0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ar0");
        pos__ = 0U;
        validate_non_negative_index("ar0", "p", p);
        context__.validate_dims("parameter initialization", "ar0", "vector_d", context__.to_vec(p));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ar0(p);
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            ar0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(1), 1, ar0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ar0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 50;
        if (!(context__.contains_r("ma0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ma0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ma0");
        pos__ = 0U;
        validate_non_negative_index("ma0", "q", q);
        context__.validate_dims("parameter initialization", "ma0", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ma0(q);
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            ma0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(1), 1, ma0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ma0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 51;
        if (!(context__.contains_r("arch")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable arch missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("arch");
        pos__ = 0U;
        validate_non_negative_index("arch", "s", s);
        context__.validate_dims("parameter initialization", "arch", "vector_d", context__.to_vec(s));
        Eigen::Matrix<double, Eigen::Dynamic, 1> arch(s);
        size_t arch_j_1_max__ = s;
        for (size_t j_1__ = 0; j_1__ < arch_j_1_max__; ++j_1__) {
            arch(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, arch);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable arch: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 52;
        if (!(context__.contains_r("garch")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable garch missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("garch");
        pos__ = 0U;
        validate_non_negative_index("garch", "k", k);
        context__.validate_dims("parameter initialization", "garch", "vector_d", context__.to_vec(k));
        Eigen::Matrix<double, Eigen::Dynamic, 1> garch(k);
        size_t garch_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < garch_j_1_max__; ++j_1__) {
            garch(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, garch);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable garch: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 53;
        if (!(context__.contains_r("mgarch")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mgarch missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mgarch");
        pos__ = 0U;
        validate_non_negative_index("mgarch", "h", h);
        context__.validate_dims("parameter initialization", "mgarch", "vector_d", context__.to_vec(h));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mgarch(h);
        size_t mgarch_j_1_max__ = h;
        for (size_t j_1__ = 0; j_1__ < mgarch_j_1_max__; ++j_1__) {
            mgarch(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(mgarch);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mgarch: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 54;
        if (!(context__.contains_r("v")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable v missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("v");
        pos__ = 0U;
        validate_non_negative_index("v", "(genT * 1)", (genT * 1));
        context__.validate_dims("parameter initialization", "v", "vector_d", context__.to_vec((genT * 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> v((genT * 1));
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            v(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(2.01, v);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable v: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 55;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "(genT * n)", (genT * n));
        context__.validate_dims("parameter initialization", "lambda", "vector_d", context__.to_vec((genT * n)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda((genT * n));
        size_t lambda_j_1_max__ = (genT * n);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(1, lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 56;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "(asym1 * 2)", (asym1 * 2));
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec((asym1 * 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma((asym1 * 2));
        size_t gamma_j_1_max__ = (asym1 * 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 46;
            local_scalar_t__ mu0;
            (void) mu0;  // dummy to suppress unused var warning
            if (jacobian__)
                mu0 = in__.scalar_constrain(lp__);
            else
                mu0 = in__.scalar_constrain();
            current_statement_begin__ = 47;
            local_scalar_t__ sigma0;
            (void) sigma0;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma0 = in__.scalar_lb_constrain(0, lp__);
            else
                sigma0 = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 48;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> breg;
            (void) breg;  // dummy to suppress unused var warning
            if (jacobian__)
                breg = in__.vector_constrain(d1, lp__);
            else
                breg = in__.vector_constrain(d1);
            current_statement_begin__ = 49;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ar0;
            (void) ar0;  // dummy to suppress unused var warning
            if (jacobian__)
                ar0 = in__.vector_lub_constrain(-(1), 1, p, lp__);
            else
                ar0 = in__.vector_lub_constrain(-(1), 1, p);
            current_statement_begin__ = 50;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ma0;
            (void) ma0;  // dummy to suppress unused var warning
            if (jacobian__)
                ma0 = in__.vector_lub_constrain(-(1), 1, q, lp__);
            else
                ma0 = in__.vector_lub_constrain(-(1), 1, q);
            current_statement_begin__ = 51;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> arch;
            (void) arch;  // dummy to suppress unused var warning
            if (jacobian__)
                arch = in__.vector_lub_constrain(0, 1, s, lp__);
            else
                arch = in__.vector_lub_constrain(0, 1, s);
            current_statement_begin__ = 52;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> garch;
            (void) garch;  // dummy to suppress unused var warning
            if (jacobian__)
                garch = in__.vector_lub_constrain(0, 1, k, lp__);
            else
                garch = in__.vector_lub_constrain(0, 1, k);
            current_statement_begin__ = 53;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mgarch;
            (void) mgarch;  // dummy to suppress unused var warning
            if (jacobian__)
                mgarch = in__.vector_constrain(h, lp__);
            else
                mgarch = in__.vector_constrain(h);
            current_statement_begin__ = 54;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v;
            (void) v;  // dummy to suppress unused var warning
            if (jacobian__)
                v = in__.vector_lb_constrain(2.01, (genT * 1), lp__);
            else
                v = in__.vector_lb_constrain(2.01, (genT * 1));
            current_statement_begin__ = 55;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.vector_lb_constrain(1, (genT * n), lp__);
            else
                lambda = in__.vector_lb_constrain(1, (genT * n));
            current_statement_begin__ = 56;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_lb_constrain(0, (asym1 * 2), lp__);
            else
                gamma = in__.vector_lb_constrain(0, (asym1 * 2));
            // transformed parameters
            current_statement_begin__ = 60;
            validate_non_negative_index("ar", "p", p);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ar(p);
            stan::math::initialize(ar, DUMMY_VAR__);
            stan::math::fill(ar, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("ma", "q", q);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ma(q);
            stan::math::initialize(ma, DUMMY_VAR__);
            stan::math::fill(ma, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 65;
            validate_non_negative_index("epsilon", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> epsilon(n);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 66;
            validate_non_negative_index("sigma", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma(n);
            stan::math::initialize(sigma, DUMMY_VAR__);
            stan::math::fill(sigma, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 74;
            for (int i = 1; i <= p; ++i) {
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 1))) {
                    current_statement_begin__ = 75;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ar0, i, "ar0", 1), 
                                "assigning variable ar");
                } else {
                    current_statement_begin__ = 76;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ar0, i, "ar0", 1)) - 1), 
                                "assigning variable ar");
                }
            }
            current_statement_begin__ = 78;
            for (int i = 1; i <= q; ++i) {
                current_statement_begin__ = 79;
                if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 1))) {
                    current_statement_begin__ = 79;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ma0, i, "ma0", 1), 
                                "assigning variable ma");
                } else {
                    current_statement_begin__ = 80;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ma0, i, "ma0", 1)) - 1), 
                                "assigning variable ma");
                }
            }
            current_statement_begin__ = 83;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 83;
                stan::math::assign(mu, multiply(xreg, breg));
            } else {
                current_statement_begin__ = 84;
                stan::math::assign(mu, rep_vector(0, n));
            }
            current_statement_begin__ = 90;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 91;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + mu0), 
                            "assigning variable mu");
                current_statement_begin__ = 92;
                stan::model::assign(sigma, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            sigma0, 
                            "assigning variable sigma");
                current_statement_begin__ = 94;
                if (as_bool(logical_gt(p, 0))) {
                    current_statement_begin__ = 94;
                    for (int j = 1; j <= p; ++j) {
                        current_statement_begin__ = 94;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 94;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(y, (i - j), "y", 1) * get_base1(ar, j, "ar", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 96;
                if (as_bool(logical_gt(q, 0))) {
                    current_statement_begin__ = 96;
                    for (int j = 1; j <= q; ++j) {
                        current_statement_begin__ = 96;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 96;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(epsilon, (i - j), "epsilon", 1) * get_base1(ma, j, "ma", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 97;
                stan::model::assign(epsilon, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1)), 
                            "assigning variable epsilon");
                current_statement_begin__ = 99;
                if (as_bool(logical_gte(s, k))) {
                    current_statement_begin__ = 101;
                    if (as_bool(logical_gt(s, 0))) {
                        current_statement_begin__ = 101;
                        for (int j = 1; j <= s; ++j) {
                            current_statement_begin__ = 101;
                            if (as_bool(logical_gt(i, j))) {
                                current_statement_begin__ = 101;
                                stan::model::assign(sigma, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            (stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "sigma") + (get_base1(arch, j, "arch", 1) * pow(get_base1(epsilon, (i - j), "epsilon", 1), 2))), 
                                            "assigning variable sigma");
                            }
                        }
                    }
                    current_statement_begin__ = 103;
                    if (as_bool(logical_gt(k, 0))) {
                        current_statement_begin__ = 103;
                        for (int j = 1; j <= k; ++j) {
                            current_statement_begin__ = 103;
                            if (as_bool(logical_gt(i, j))) {
                                current_statement_begin__ = 103;
                                stan::model::assign(sigma, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            (stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "sigma") + (get_base1(garch, j, "garch", 1) * pow(get_base1(sigma, (i - j), "sigma", 1), 2))), 
                                            "assigning variable sigma");
                            }
                        }
                    }
                }
                current_statement_begin__ = 106;
                if (as_bool(logical_eq(genT, 1))) {
                    current_statement_begin__ = 106;
                    stan::model::assign(sigma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                stan::math::sqrt(((((get_base1(v, 1, "v", 1) - 2) * get_base1(lambda, i, "lambda", 1)) * get_base1(sigma, i, "sigma", 1)) / get_base1(v, 1, "v", 1))), 
                                "assigning variable sigma");
                } else {
                    current_statement_begin__ = 107;
                    stan::model::assign(sigma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                stan::math::sqrt(get_base1(sigma, i, "sigma", 1)), 
                                "assigning variable sigma");
                }
                current_statement_begin__ = 109;
                if (as_bool(logical_gt(h, 0))) {
                    current_statement_begin__ = 109;
                    for (int j = 1; j <= h; ++j) {
                        current_statement_begin__ = 109;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 109;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(mgarch, j, "mgarch", 1) * get_base1(sigma, ((i - j) + 1), "sigma", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 112;
                if (as_bool(logical_eq(asym1, 1))) {
                    current_statement_begin__ = 112;
                    if (as_bool(logical_gt(i, 1))) {
                        current_statement_begin__ = 112;
                        stan::model::assign(sigma, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "sigma") + (get_base1(gamma, 1, "gamma", 1) * asymf(get_base1(epsilon, (i - 1), "epsilon", 1), get_base1(gamma, 2, "gamma", 1), asym, pstream__))), 
                                    "assigning variable sigma");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 60;
            size_t ar_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ar(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ar" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ar: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 61;
            size_t ma_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ma(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ma" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 64;
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 65;
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(epsilon(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: epsilon" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable epsilon: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 66;
            size_t sigma_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sigma(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "sigma", sigma, 0);
            // model body
            current_statement_begin__ = 117;
            if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 1))) {
                current_statement_begin__ = 117;
                lp_accum__.add(normal_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 2))) {
                current_statement_begin__ = 118;
                lp_accum__.add(beta_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 3))) {
                current_statement_begin__ = 119;
                lp_accum__.add(uniform_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 4))) {
                current_statement_begin__ = 120;
                lp_accum__.add(student_t_log(mu0, get_base1(prior_mu0, 3, "prior_mu0", 1), get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 5))) {
                current_statement_begin__ = 121;
                lp_accum__.add(cauchy_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 6))) {
                current_statement_begin__ = 122;
                lp_accum__.add(inv_gamma_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 7))) {
                current_statement_begin__ = 123;
                lp_accum__.add(inv_chi_square_log(mu0, get_base1(prior_mu0, 3, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 8))) {
                current_statement_begin__ = 124;
                lp_accum__.add(-(stan::math::log(sigma0)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 9))) {
                current_statement_begin__ = 125;
                lp_accum__.add(gamma_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 10))) {
                current_statement_begin__ = 126;
                lp_accum__.add(exponential_log(mu0, get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 11))) {
                current_statement_begin__ = 127;
                lp_accum__.add(chi_square_log(mu0, get_base1(prior_mu0, 3, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 12))) {
                current_statement_begin__ = 128;
                lp_accum__.add(double_exponential_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            }
            current_statement_begin__ = 131;
            if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 1))) {
                current_statement_begin__ = 131;
                lp_accum__.add(normal_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 2))) {
                current_statement_begin__ = 132;
                lp_accum__.add(beta_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 3))) {
                current_statement_begin__ = 133;
                lp_accum__.add(uniform_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 4))) {
                current_statement_begin__ = 134;
                lp_accum__.add(student_t_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1), get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 5))) {
                current_statement_begin__ = 135;
                lp_accum__.add(cauchy_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 6))) {
                current_statement_begin__ = 136;
                lp_accum__.add(inv_gamma_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 7))) {
                current_statement_begin__ = 137;
                lp_accum__.add(inv_chi_square_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 8))) {
                current_statement_begin__ = 138;
                lp_accum__.add(-(stan::math::log(sigma0)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 9))) {
                current_statement_begin__ = 139;
                lp_accum__.add(gamma_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 10))) {
                current_statement_begin__ = 140;
                lp_accum__.add(exponential_log(sigma0, get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 11))) {
                current_statement_begin__ = 141;
                lp_accum__.add(chi_square_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 12))) {
                current_statement_begin__ = 142;
                lp_accum__.add(double_exponential_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            }
            current_statement_begin__ = 145;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 146;
                for (int i = 1; i <= d1; ++i) {
                    current_statement_begin__ = 147;
                    if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 1))) {
                        current_statement_begin__ = 147;
                        lp_accum__.add(normal_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 2))) {
                        current_statement_begin__ = 148;
                        lp_accum__.add(beta_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 3))) {
                        current_statement_begin__ = 149;
                        lp_accum__.add(uniform_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 4))) {
                        current_statement_begin__ = 150;
                        lp_accum__.add(student_t_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 5))) {
                        current_statement_begin__ = 151;
                        lp_accum__.add(cauchy_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 6))) {
                        current_statement_begin__ = 152;
                        lp_accum__.add(inv_gamma_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 7))) {
                        current_statement_begin__ = 153;
                        lp_accum__.add(inv_chi_square_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 8))) {
                        current_statement_begin__ = 154;
                        lp_accum__.add(-(stan::math::log(sigma0)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 9))) {
                        current_statement_begin__ = 155;
                        lp_accum__.add(gamma_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 10))) {
                        current_statement_begin__ = 156;
                        lp_accum__.add(exponential_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 11))) {
                        current_statement_begin__ = 157;
                        lp_accum__.add(chi_square_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 12))) {
                        current_statement_begin__ = 158;
                        lp_accum__.add(double_exponential_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    }
                }
            }
            current_statement_begin__ = 163;
            if (as_bool(logical_gt(p, 0))) {
                current_statement_begin__ = 164;
                for (int i = 1; i <= p; ++i) {
                    current_statement_begin__ = 165;
                    if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 1))) {
                        current_statement_begin__ = 165;
                        lp_accum__.add(normal_log(get_base1(ar0, i, "ar0", 1), get_base1(prior_ar, i, 1, "prior_ar", 1), get_base1(prior_ar, i, 2, "prior_ar", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 2))) {
                        current_statement_begin__ = 166;
                        lp_accum__.add(beta_log(stan::math::fabs(get_base1(ar0, i, "ar0", 1)), get_base1(prior_ar, i, 1, "prior_ar", 1), get_base1(prior_ar, i, 2, "prior_ar", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 3))) {
                        current_statement_begin__ = 167;
                        lp_accum__.add(uniform_log(get_base1(ar0, i, "ar0", 1), get_base1(prior_ar, i, 1, "prior_ar", 1), get_base1(prior_ar, i, 2, "prior_ar", 1)));
                    }
                }
            }
            current_statement_begin__ = 171;
            if (as_bool(logical_gt(q, 0))) {
                current_statement_begin__ = 172;
                for (int i = 1; i <= q; ++i) {
                    current_statement_begin__ = 173;
                    if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 1))) {
                        current_statement_begin__ = 173;
                        lp_accum__.add(normal_log(get_base1(ma0, i, "ma0", 1), get_base1(prior_ma, i, 1, "prior_ma", 1), get_base1(prior_ma, i, 2, "prior_ma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 2))) {
                        current_statement_begin__ = 174;
                        lp_accum__.add(beta_log(stan::math::fabs(get_base1(ma0, i, "ma0", 1)), get_base1(prior_ma, i, 1, "prior_ma", 1), get_base1(prior_ma, i, 2, "prior_ma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 3))) {
                        current_statement_begin__ = 175;
                        lp_accum__.add(uniform_log(get_base1(ma0, i, "ma0", 1), get_base1(prior_ma, i, 1, "prior_ma", 1), get_base1(prior_ma, i, 2, "prior_ma", 1)));
                    }
                }
            }
            current_statement_begin__ = 180;
            if (as_bool(logical_gt(s, 0))) {
                current_statement_begin__ = 181;
                for (int i = 1; i <= s; ++i) {
                    current_statement_begin__ = 182;
                    if (as_bool(logical_eq(get_base1(prior_arch, i, 4, "prior_arch", 1), 1))) {
                        current_statement_begin__ = 182;
                        lp_accum__.add(normal_log(get_base1(arch, i, "arch", 1), get_base1(prior_arch, i, 1, "prior_arch", 1), get_base1(prior_arch, i, 2, "prior_arch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_arch, i, 4, "prior_arch", 1), 2))) {
                        current_statement_begin__ = 183;
                        lp_accum__.add(beta_log(get_base1(arch, i, "arch", 1), get_base1(prior_arch, i, 1, "prior_arch", 1), get_base1(prior_arch, i, 2, "prior_arch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_arch, i, 4, "prior_arch", 1), 3))) {
                        current_statement_begin__ = 184;
                        lp_accum__.add(uniform_log(get_base1(arch, i, "arch", 1), get_base1(prior_arch, i, 1, "prior_arch", 1), get_base1(prior_arch, i, 2, "prior_arch", 1)));
                    }
                }
            }
            current_statement_begin__ = 189;
            if (as_bool(logical_gt(k, 0))) {
                current_statement_begin__ = 190;
                for (int i = 1; i <= k; ++i) {
                    current_statement_begin__ = 191;
                    if (as_bool(logical_eq(get_base1(prior_garch, i, 4, "prior_garch", 1), 1))) {
                        current_statement_begin__ = 191;
                        lp_accum__.add(normal_log(get_base1(garch, i, "garch", 1), get_base1(prior_garch, i, 1, "prior_garch", 1), get_base1(prior_garch, i, 2, "prior_garch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_garch, i, 4, "prior_garch", 1), 2))) {
                        current_statement_begin__ = 192;
                        lp_accum__.add(beta_log(get_base1(garch, i, "garch", 1), get_base1(prior_garch, i, 1, "prior_garch", 1), get_base1(prior_garch, i, 2, "prior_garch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_garch, i, 4, "prior_garch", 1), 3))) {
                        current_statement_begin__ = 193;
                        lp_accum__.add(uniform_log(get_base1(garch, i, "garch", 1), get_base1(prior_garch, i, 1, "prior_garch", 1), get_base1(prior_garch, i, 2, "prior_garch", 1)));
                    }
                }
            }
            current_statement_begin__ = 197;
            if (as_bool(logical_gt(h, 0))) {
                current_statement_begin__ = 198;
                for (int i = 1; i <= h; ++i) {
                    current_statement_begin__ = 199;
                    if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 1))) {
                        current_statement_begin__ = 199;
                        lp_accum__.add(normal_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 2))) {
                        current_statement_begin__ = 200;
                        lp_accum__.add(beta_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 3))) {
                        current_statement_begin__ = 201;
                        lp_accum__.add(uniform_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 4))) {
                        current_statement_begin__ = 202;
                        lp_accum__.add(student_t_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 3, "prior_mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 5))) {
                        current_statement_begin__ = 203;
                        lp_accum__.add(cauchy_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 6))) {
                        current_statement_begin__ = 204;
                        lp_accum__.add(inv_gamma_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 7))) {
                        current_statement_begin__ = 205;
                        lp_accum__.add(inv_chi_square_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 3, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 8))) {
                        current_statement_begin__ = 206;
                        lp_accum__.add(-(stan::math::log(sigma0)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 9))) {
                        current_statement_begin__ = 207;
                        lp_accum__.add(gamma_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 10))) {
                        current_statement_begin__ = 208;
                        lp_accum__.add(exponential_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 11))) {
                        current_statement_begin__ = 209;
                        lp_accum__.add(chi_square_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 3, "prior_mgarch", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_mgarch, i, 4, "prior_mgarch", 1), 12))) {
                        current_statement_begin__ = 210;
                        lp_accum__.add(double_exponential_log(get_base1(mgarch, i, "mgarch", 1), get_base1(prior_mgarch, i, 1, "prior_mgarch", 1), get_base1(prior_mgarch, i, 2, "prior_mgarch", 1)));
                    }
                }
            }
            current_statement_begin__ = 213;
            if (as_bool(logical_eq(genT, 1))) {
                current_statement_begin__ = 215;
                if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 1))) {
                    current_statement_begin__ = 215;
                    lp_accum__.add(normal_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 2))) {
                    current_statement_begin__ = 216;
                    lp_accum__.add(beta_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 3))) {
                    current_statement_begin__ = 217;
                    lp_accum__.add(uniform_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 4))) {
                    current_statement_begin__ = 218;
                    lp_accum__.add(student_t_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 3, "prior_dfv", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 5))) {
                    current_statement_begin__ = 219;
                    lp_accum__.add(cauchy_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 6))) {
                    current_statement_begin__ = 220;
                    lp_accum__.add(inv_gamma_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 7))) {
                    current_statement_begin__ = 221;
                    lp_accum__.add(inv_chi_square_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 3, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 8))) {
                    current_statement_begin__ = 222;
                    lp_accum__.add(stan::math::log(Jpv(get_base1(v, 1, "v", 1), pstream__)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 9))) {
                    current_statement_begin__ = 223;
                    lp_accum__.add(gamma_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 10))) {
                    current_statement_begin__ = 224;
                    lp_accum__.add(exponential_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 11))) {
                    current_statement_begin__ = 225;
                    lp_accum__.add(chi_square_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 3, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 12))) {
                    current_statement_begin__ = 226;
                    lp_accum__.add(double_exponential_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                }
            }
            current_statement_begin__ = 229;
            if (as_bool(logical_eq(asym1, 1))) {
                current_statement_begin__ = 230;
                for (int i = 1; i <= 2; ++i) {
                    current_statement_begin__ = 231;
                    if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 1))) {
                        current_statement_begin__ = 231;
                        lp_accum__.add(normal_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 2))) {
                        current_statement_begin__ = 232;
                        lp_accum__.add(beta_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 3))) {
                        current_statement_begin__ = 233;
                        lp_accum__.add(uniform_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 4))) {
                        current_statement_begin__ = 234;
                        lp_accum__.add(student_t_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 3, "prior_gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 5))) {
                        current_statement_begin__ = 235;
                        lp_accum__.add(cauchy_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 6))) {
                        current_statement_begin__ = 236;
                        lp_accum__.add(inv_gamma_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 7))) {
                        current_statement_begin__ = 237;
                        lp_accum__.add(inv_chi_square_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 3, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 8))) {
                        current_statement_begin__ = 238;
                        lp_accum__.add(-(stan::math::log(sigma0)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 9))) {
                        current_statement_begin__ = 239;
                        lp_accum__.add(gamma_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 10))) {
                        current_statement_begin__ = 240;
                        lp_accum__.add(exponential_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 11))) {
                        current_statement_begin__ = 241;
                        lp_accum__.add(chi_square_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 3, "prior_gamma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_gamma, i, 4, "prior_gamma", 1), 12))) {
                        current_statement_begin__ = 242;
                        lp_accum__.add(double_exponential_log(get_base1(gamma, i, "gamma", 1), get_base1(prior_gamma, i, 1, "prior_gamma", 1), get_base1(prior_gamma, i, 2, "prior_gamma", 1)));
                    }
                }
            }
            current_statement_begin__ = 247;
            if (as_bool(logical_eq(genT, 1))) {
                current_statement_begin__ = 247;
                lp_accum__.add(inv_gamma_log(lambda, (get_base1(v, 1, "v", 1) / 2), (get_base1(v, 1, "v", 1) / 2)));
            }
            current_statement_begin__ = 248;
            lp_accum__.add(normal_log(epsilon, 0, sigma));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu0");
        names__.push_back("sigma0");
        names__.push_back("breg");
        names__.push_back("ar0");
        names__.push_back("ma0");
        names__.push_back("arch");
        names__.push_back("garch");
        names__.push_back("mgarch");
        names__.push_back("v");
        names__.push_back("lambda");
        names__.push_back("gamma");
        names__.push_back("ar");
        names__.push_back("ma");
        names__.push_back("mu");
        names__.push_back("epsilon");
        names__.push_back("sigma");
        names__.push_back("loglik");
        names__.push_back("log_lik");
        names__.push_back("fit");
        names__.push_back("residuals");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(d1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(s);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(h);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((genT * 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((genT * n));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((asym1 * 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_tgarch_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double mu0 = in__.scalar_constrain();
        vars__.push_back(mu0);
        double sigma0 = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma0);
        Eigen::Matrix<double, Eigen::Dynamic, 1> breg = in__.vector_constrain(d1);
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            vars__.push_back(breg(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> ar0 = in__.vector_lub_constrain(-(1), 1, p);
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            vars__.push_back(ar0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> ma0 = in__.vector_lub_constrain(-(1), 1, q);
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            vars__.push_back(ma0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> arch = in__.vector_lub_constrain(0, 1, s);
        size_t arch_j_1_max__ = s;
        for (size_t j_1__ = 0; j_1__ < arch_j_1_max__; ++j_1__) {
            vars__.push_back(arch(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> garch = in__.vector_lub_constrain(0, 1, k);
        size_t garch_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < garch_j_1_max__; ++j_1__) {
            vars__.push_back(garch(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> mgarch = in__.vector_constrain(h);
        size_t mgarch_j_1_max__ = h;
        for (size_t j_1__ = 0; j_1__ < mgarch_j_1_max__; ++j_1__) {
            vars__.push_back(mgarch(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> v = in__.vector_lb_constrain(2.01, (genT * 1));
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            vars__.push_back(v(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda = in__.vector_lb_constrain(1, (genT * n));
        size_t lambda_j_1_max__ = (genT * n);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            vars__.push_back(lambda(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_lb_constrain(0, (asym1 * 2));
        size_t gamma_j_1_max__ = (asym1 * 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 60;
            validate_non_negative_index("ar", "p", p);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ar(p);
            stan::math::initialize(ar, DUMMY_VAR__);
            stan::math::fill(ar, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("ma", "q", q);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ma(q);
            stan::math::initialize(ma, DUMMY_VAR__);
            stan::math::fill(ma, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 65;
            validate_non_negative_index("epsilon", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> epsilon(n);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 66;
            validate_non_negative_index("sigma", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sigma(n);
            stan::math::initialize(sigma, DUMMY_VAR__);
            stan::math::fill(sigma, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 74;
            for (int i = 1; i <= p; ++i) {
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 1))) {
                    current_statement_begin__ = 75;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ar0, i, "ar0", 1), 
                                "assigning variable ar");
                } else {
                    current_statement_begin__ = 76;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ar0, i, "ar0", 1)) - 1), 
                                "assigning variable ar");
                }
            }
            current_statement_begin__ = 78;
            for (int i = 1; i <= q; ++i) {
                current_statement_begin__ = 79;
                if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 1))) {
                    current_statement_begin__ = 79;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ma0, i, "ma0", 1), 
                                "assigning variable ma");
                } else {
                    current_statement_begin__ = 80;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ma0, i, "ma0", 1)) - 1), 
                                "assigning variable ma");
                }
            }
            current_statement_begin__ = 83;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 83;
                stan::math::assign(mu, multiply(xreg, breg));
            } else {
                current_statement_begin__ = 84;
                stan::math::assign(mu, rep_vector(0, n));
            }
            current_statement_begin__ = 90;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 91;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + mu0), 
                            "assigning variable mu");
                current_statement_begin__ = 92;
                stan::model::assign(sigma, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            sigma0, 
                            "assigning variable sigma");
                current_statement_begin__ = 94;
                if (as_bool(logical_gt(p, 0))) {
                    current_statement_begin__ = 94;
                    for (int j = 1; j <= p; ++j) {
                        current_statement_begin__ = 94;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 94;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(y, (i - j), "y", 1) * get_base1(ar, j, "ar", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 96;
                if (as_bool(logical_gt(q, 0))) {
                    current_statement_begin__ = 96;
                    for (int j = 1; j <= q; ++j) {
                        current_statement_begin__ = 96;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 96;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(epsilon, (i - j), "epsilon", 1) * get_base1(ma, j, "ma", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 97;
                stan::model::assign(epsilon, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1)), 
                            "assigning variable epsilon");
                current_statement_begin__ = 99;
                if (as_bool(logical_gte(s, k))) {
                    current_statement_begin__ = 101;
                    if (as_bool(logical_gt(s, 0))) {
                        current_statement_begin__ = 101;
                        for (int j = 1; j <= s; ++j) {
                            current_statement_begin__ = 101;
                            if (as_bool(logical_gt(i, j))) {
                                current_statement_begin__ = 101;
                                stan::model::assign(sigma, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            (stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "sigma") + (get_base1(arch, j, "arch", 1) * pow(get_base1(epsilon, (i - j), "epsilon", 1), 2))), 
                                            "assigning variable sigma");
                            }
                        }
                    }
                    current_statement_begin__ = 103;
                    if (as_bool(logical_gt(k, 0))) {
                        current_statement_begin__ = 103;
                        for (int j = 1; j <= k; ++j) {
                            current_statement_begin__ = 103;
                            if (as_bool(logical_gt(i, j))) {
                                current_statement_begin__ = 103;
                                stan::model::assign(sigma, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            (stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "sigma") + (get_base1(garch, j, "garch", 1) * pow(get_base1(sigma, (i - j), "sigma", 1), 2))), 
                                            "assigning variable sigma");
                            }
                        }
                    }
                }
                current_statement_begin__ = 106;
                if (as_bool(logical_eq(genT, 1))) {
                    current_statement_begin__ = 106;
                    stan::model::assign(sigma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                stan::math::sqrt(((((get_base1(v, 1, "v", 1) - 2) * get_base1(lambda, i, "lambda", 1)) * get_base1(sigma, i, "sigma", 1)) / get_base1(v, 1, "v", 1))), 
                                "assigning variable sigma");
                } else {
                    current_statement_begin__ = 107;
                    stan::model::assign(sigma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                stan::math::sqrt(get_base1(sigma, i, "sigma", 1)), 
                                "assigning variable sigma");
                }
                current_statement_begin__ = 109;
                if (as_bool(logical_gt(h, 0))) {
                    current_statement_begin__ = 109;
                    for (int j = 1; j <= h; ++j) {
                        current_statement_begin__ = 109;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 109;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(mgarch, j, "mgarch", 1) * get_base1(sigma, ((i - j) + 1), "sigma", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 112;
                if (as_bool(logical_eq(asym1, 1))) {
                    current_statement_begin__ = 112;
                    if (as_bool(logical_gt(i, 1))) {
                        current_statement_begin__ = 112;
                        stan::model::assign(sigma, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "sigma") + (get_base1(gamma, 1, "gamma", 1) * asymf(get_base1(epsilon, (i - 1), "epsilon", 1), get_base1(gamma, 2, "gamma", 1), asym, pstream__))), 
                                    "assigning variable sigma");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 66;
            check_greater_or_equal(function__, "sigma", sigma, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t ar_j_1_max__ = p;
                for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                    vars__.push_back(ar(j_1__));
                }
                size_t ma_j_1_max__ = q;
                for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                    vars__.push_back(ma(j_1__));
                }
                size_t mu_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t epsilon_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                    vars__.push_back(epsilon(j_1__));
                }
                size_t sigma_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                    vars__.push_back(sigma(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 251;
            double loglik;
            (void) loglik;  // dummy to suppress unused var warning
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);
            stan::math::assign(loglik,0);
            current_statement_begin__ = 252;
            validate_non_negative_index("log_lik", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(n);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 253;
            validate_non_negative_index("fit", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fit(n);
            stan::math::initialize(fit, DUMMY_VAR__);
            stan::math::fill(fit, DUMMY_VAR__);
            current_statement_begin__ = 254;
            validate_non_negative_index("residuals", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> residuals(n);
            stan::math::initialize(residuals, DUMMY_VAR__);
            stan::math::fill(residuals, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 256;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 257;
                if (as_bool(logical_eq(genT, 1))) {
                    current_statement_begin__ = 258;
                    stan::model::assign(residuals, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                student_t_rng(get_base1(v, 1, "v", 1), get_base1(epsilon, i, "epsilon", 1), get_base1(sigma, i, "sigma", 1), base_rng__), 
                                "assigning variable residuals");
                    current_statement_begin__ = 259;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                student_t_log(get_base1(y, i, "y", 1), get_base1(v, 1, "v", 1), get_base1(mu, i, "mu", 1), get_base1(sigma, i, "sigma", 1)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 260;
                    stan::math::assign(loglik, (loglik + get_base1(log_lik, i, "log_lik", 1)));
                } else {
                    current_statement_begin__ = 263;
                    stan::model::assign(residuals, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                normal_rng(get_base1(epsilon, i, "epsilon", 1), get_base1(sigma, i, "sigma", 1), base_rng__), 
                                "assigning variable residuals");
                    current_statement_begin__ = 264;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                normal_log(get_base1(y, i, "y", 1), get_base1(mu, i, "mu", 1), get_base1(sigma, i, "sigma", 1)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 265;
                    stan::math::assign(loglik, (loglik + get_base1(log_lik, i, "log_lik", 1)));
                }
            }
            current_statement_begin__ = 268;
            stan::math::assign(fit, subtract(y, residuals));
            // validate, write generated quantities
            current_statement_begin__ = 251;
            vars__.push_back(loglik);
            current_statement_begin__ = 252;
            size_t log_lik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 253;
            size_t fit_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
                vars__.push_back(fit(j_1__));
            }
            current_statement_begin__ = 254;
            size_t residuals_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
                vars__.push_back(residuals(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_tgarch";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma0";
        param_names__.push_back(param_name_stream__.str());
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "breg" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ar0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ma0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t arch_j_1_max__ = s;
        for (size_t j_1__ = 0; j_1__ < arch_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "arch" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t garch_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < garch_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "garch" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mgarch_j_1_max__ = h;
        for (size_t j_1__ = 0; j_1__ < mgarch_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mgarch" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = (genT * n);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_j_1_max__ = (asym1 * 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ar_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ma_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t sigma_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "loglik";
        param_names__.push_back(param_name_stream__.str());
        size_t log_lik_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t residuals_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma0";
        param_names__.push_back(param_name_stream__.str());
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "breg" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ar0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ma0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t arch_j_1_max__ = s;
        for (size_t j_1__ = 0; j_1__ < arch_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "arch" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t garch_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < garch_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "garch" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mgarch_j_1_max__ = h;
        for (size_t j_1__ = 0; j_1__ < mgarch_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mgarch" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = (genT * n);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_j_1_max__ = (asym1 * 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ar_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ma_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t sigma_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "loglik";
        param_names__.push_back(param_name_stream__.str());
        size_t log_lik_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t residuals_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_tgarch_namespace::model_tgarch stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
