% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{log_lik.varstan}
\alias{log_lik.varstan}
\alias{log_lik}
\title{Extract posterior sample of the pointwise log-likelihood from a varstan object.}
\usage{
\method{log_lik}{varstan}(object, permuted = TRUE, ...)
}
\arguments{
\item{object}{A varstan object of the time series fitted model.}

\item{permuted}{A logical scalar indicating whether the draws after
the \code{warmup} period in each chain should be permuted and merged.
If FALSE, the original order is kept. For each \code{stanfit} object,
the permutation is fixed (i.e., extracting samples a second time
will give the same sequence of iterations).}

\item{...}{additional values need in log_lik methods}
}
\value{
Usually, an S x N matrix containing the pointwise log-likelihood
samples, where S is the number of samples and N is the number
of observations in the data. If \code{permuted} is \code{FALSE},
an S x N x R array is returned, where R is the number of fitted
chains.
}
\description{
Convenience function for extracting the pointwise log-likelihood
matrix or array from a fitted Stan model.
}
\examples{

\donttest{
 library(astsa)
 model = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
 fit1 = varstan(model,chains = 1)

 log1 <- log_lik(fit1)
 log1
}

}
\references{
Vehtari, A., Gelman, A., & Gabry J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. \emph{In Statistics
and Computing}, \code{doi:10.1007/s11222-016-9696-4}.

Gelman, A., Hwang, J., & Vehtari, A. (2014). Understanding predictive
information criteria for Bayesian models. \emph{Statistics and Computing}.
24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation
and widely applicable information criterion in singular learning theory.
\emph{The Journal of Machine Learning Research}. 11, 3571-3594.
}
