% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_node_related_methods.R
\name{node_prediction_training_data_indices}
\alias{node_prediction_training_data_indices}
\title{Gets node predictions indices of the training data for new data.}
\usage{
node_prediction_training_data_indices(bart_machine, new_data = NULL)
}
\arguments{
\item{bart_machine}{An object of class ``bartMachine''.}

\item{new_data}{Data that you wish to investigate the training sample weights. If \code{NULL}, the original training data is used.}
}
\value{
Returns a binary tensor indicating whether the prediction node contained a training datum or not. For each observation in new data, the size of this tensor is number of gibbs sample after burn-in
times the number of trees times the number of training data observations. This the size of the full tensor is the number of observations in the new data times the three dimensional object just explained.
}
\description{
This returns a binary tensor for all gibbs samples after burn-in for all trees and for all training observations.
}
\examples{
\dontrun{
set.seed(11)
n = 50
X = data.frame(x1 = rnorm(n), x2 = runif(n))
y = X$x1 + rnorm(n)
bart_machine = bartMachine(X, y, flush_indices_to_save_RAM = FALSE)
idx = node_prediction_training_data_indices(bart_machine)
}
}
