% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_mean_sd_trends.R
\name{calculate_mean_sd_trends}
\alias{calculate_mean_sd_trends}
\title{Calculate the Mean-Variance trend}
\usage{
calculate_mean_sd_trends(data, design_matrix)
}
\arguments{
\item{data}{A \code{tibble} or \code{data.frame} to annotate with mean and sd}

\item{design_matrix}{A design matrix for the data (see example).}
}
\value{
A \code{tibble} or \code{data.frame} with the mean and sd vectors
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculates the mean and standard deviation of each row (peptide)
and adds them as new columns. Assumes that the condition names are the
names in the design matrix.
}
\examples{

# Setup model matrix
design <- model.matrix(~ 0 + factor(rep(1:2, each = 3)))
colnames(design) <- paste0("ng", c(50, 100))

yeast \%>\%
    # Normalize data
    psrn("identifier") \%>\%
    # Get mean-variance trends
    calculate_mean_sd_trends(design)
}
