% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_template}
\alias{make_template}
\title{make a mapping template for model fitting}
\usage{
make_template(patho, cause_list)
}
\arguments{
\item{patho}{A vector of pathogen names for a particular measurement slice.
\code{patho} must be a substring of some elements in \code{cause_list}, e.g.,
"PNEU" is a substring of "PNEU_VT13". Also see Examples for this function.}

\item{cause_list}{A vector of characters; Potential categories of latent statuses.}
}
\value{
a mapping from \code{patho} to \code{cause_list}.
\code{NROW = length(cause_list)+1};
\code{NCOL = length(patho)}. This value is crucial in model fitting to determine
which measurements are informative of a particular category of latent status.
}
\description{
\code{make_template} creates a mapping matrix (binary values). Each pathogen
in a measurement slice (e.g., nasal-pharyngeal PCR test) is mapped to inform
one category of latent status. All the possible categories (e.g., causes of pneumonia)
remain the same regardless of the measurement slice used (e.g., NPPCR or BCX).
}
\details{
The first argument has to be character substrings from the second argument.
For example, the two arguments can respectively be \code{"A"} and \code{"A_1"},
or \code{"A"} and \code{"A+B"}.The second argument can have character strings not
matched in the first argument. If so, it means some causes of diseases are not
directly measured in the current measurement slice.
For each element of \code{patho}, the function matches from the start of the strings
of \code{cause_list}. Therefore, make sure that latent statuses from the same family
(e.g., "PNEU_VT13" and "PNEU_NOVT13") need to start with the same family name
(e.g., "PNEU") followed by subcategories (e.g., "_VT13" and "_NOVT13").
}
\examples{

cause_list <- c("HINF","PNEU_VT13","PNEU_NOVT13","SAUR","HMPV_A_B","FLU_A",
"PARA_1","PARA_3","PARA_4","PV_EV","RHINO","RSV", "ENTRB","TB")

patho_BrS_NPPCR <- c("HINF","PNEU","SAUR","HMPV_A_B","FLU_A","PARA_1",
"PARA_3","PARA_4","PV_EV","RHINO","RSV")
make_template(patho_BrS_NPPCR,cause_list)


 cause = c("A","B1","B2","C","A+C","B+C")
 patho = c("A","B","C")
 make_template(patho,cause)
 
 cause = c("A","B1","B2","C","A+C","B+C","other")
 patho = c("A","B","C")
 make_template(patho,cause)
 
 
 cause = c("A","B1","B2","X_B","Y_B","C","A+C","B+C","other")
 patho = c("A","B","C","X_B","Y_B")
 make_template(patho,cause)
 
 
}
