% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{atlas.csv}
\alias{atlas.csv}
\title{Queries ATLAS with a CSV() command and imports the contents of the csv into a data frame}
\usage{
atlas.csv(connection, query, file_name = NULL)
}
\arguments{
\item{connection}{connection object returned from connect(url) function}

\item{query}{ATLAS CSV query}

\item{file_name}{if specified, stores the csv into the file_name, otherwise the temporary
file used to download the data will be deleted after the data.frame is generated}
}
\value{
data frame containing CSV file
}
\description{
Queries ATLAS with a CSV() command and imports the contents of the csv into a data frame
}
\examples{
\donttest{atlas.csv(atlas.connection('http://localhost:8080'), 'CSV("ICD9=250.50", CPT, LABS, ICD9)')}
\donttest{atlas.csv(atlas.connection('http://localhost:8080'), 'CSV("ICD9=250.50", CPT, LABS, ICD9)',
          '/output.csv')}

}
