% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableby.control.R
\name{tableby.control}
\alias{tableby.control}
\title{Control settings for \code{tableby} function}
\usage{
tableby.control(test = TRUE, total = TRUE, test.pname = NULL,
  cat.simplify = FALSE, numeric.test = "anova", cat.test = "chisq",
  ordered.test = "trend", surv.test = "logrank", date.test = "kwt",
  numeric.stats = c("Nmiss", "meansd", "q1q3", "range"),
  cat.stats = c("Nmiss", "countpct"), ordered.stats = c("Nmiss",
  "countpct"), surv.stats = c("Nevents", "medSurv"), date.stats = c("Nmiss",
  "median", "range"), stats.labels = list(Nmiss = "N-Miss", Nmiss2 = "N-Miss",
  meansd = "Mean (SD)", q1q3 = "Q1, Q3", range = "Range", countpct =
  "Count (Pct)", Nevents = "Events", medsurv = "Median Survival"), digits = 3,
  digits.test = NULL, nsmall = NULL, nsmall.pct = NULL, ...)
}
\arguments{
\item{test}{logical, telling \code{tableby} whether to perform tests of x variables across levels of the group variable.}

\item{total}{logical, telling \code{tableby} whether to calculate a column of totals across group variable.}

\item{test.pname}{character string denoting the p-value column name in \code{\link{summary.tableby}}.
Modifiable also with \code{\link{modpval.tableby}}.}

\item{cat.simplify}{logical, tell \code{tableby} whether to include the first level of the categorical variable if binary.
If \code{TRUE}, only the summary stats of the second level, and total (if \code{TRUE}), are calculated.
NOTE: this only simplifies to one line if \code{cat.stats} is only one statistic, such as countpct.
Specifically, if \code{cat.stats} includes Nmiss and there are missings, then Nmiss is included in the stats.}

\item{numeric.test}{set test for numeric RHS variables in \code{tableby} to anova or kwt (Kruskal-Wallis) rank-based tests.
If no LHS variable exists, then a mean is required for a univariate test.}

\item{cat.test}{name of test for categorical variables: chisq, fe (Fisher's Exact)}

\item{ordered.test}{name of test for ordered variables: trend}

\item{surv.test}{name of test to perform for survival variables: logrank}

\item{date.test}{name of test to perform for date variables.}

\item{numeric.stats}{summary statistics to include for numeric RHS variables of \code{tableby} within the levels of the group LHS variable.
Options are N, Nmiss, mean, meansd, median, q1q3, range, or other R built-in or user-written functions.}

\item{cat.stats}{summary statistics to include for categorical RHS variables of \code{tableby} within the levels of the group LHS variable.
Options are N, Nmiss, count, countpct, or other R built-in or user-written functions.}

\item{ordered.stats}{summary statistics to include for categorical RHS variables of \code{tableby} within the levels of the group LHS variable.
Options are N, Nmiss, count, countpct, or other R built-in or user-written functions.}

\item{surv.stats}{summary statistics to include for time-to-event (survival) RHS variables of \code{tableby} within the levels of the group LHS variable.
Options are Nevents, medsurv.}

\item{date.stats}{stats functions to perform for Date variables}

\item{stats.labels}{A named list of labels for all the statistics function names, where the function name is the named element in the list
and the value that goes with it is a string containing the formal name that will be printed in all printed renderings of the output,
e.g., list(countpct="Count(Pct)").}

\item{digits}{digits to print for non-integer statistics}

\item{digits.test}{digits to print for test statistic p-values}

\item{nsmall}{digits to print after decimal point for numerics}

\item{nsmall.pct}{digits to print after decimal point for percentages}

\item{...}{additional arguments to be passed to internal \code{tableby} functions and kept for summary method options, such as digits.}
}
\value{
A list with settings to be used within the \code{tableby} function.
}
\description{
Control test and summary settings for the \code{\link{tableby}} function.
}
\details{
All tests can be turned off by setting \code{test} to FALSE.
  Otherwise, test are set to default settings in this list, or set explicitly in the formula of \code{tableby}.
}
\examples{
set.seed(100)
## make 3+ categories for Response
mdat <- data.frame(Response=c(0,0,0,0,0,1,1,1,1,1),
                   Sex=sample(c("Male", "Female"), 10,replace=TRUE),
                   Age=round(rnorm(10,mean=40, sd=5)),
                   HtIn=round(rnorm(10,mean=65,sd=5)))
                   
## allow default summaries in RHS variables, and pass control args to
## main function, to be picked up with ... when calling tableby.control
outResp <- tableby(Response ~ Sex + Age + HtIn, data=mdat, total=FALSE, test=TRUE)
outCtl <- tableby(Response ~ Sex + Age + HtIn, data=mdat,
                  control=tableby.control(total=TRUE, cat.simplify=TRUE,
                  cat.stats=c("Nmiss","countpct"),digits=1))
summary(outResp, text=TRUE)
summary(outCtl, text=TRUE)
}
\author{
Jason Sinnwell, Beth Atkinson, Terry Therneau, adapted from SAS Macros written by Paul Novotny and Ryan Lennon
}
\seealso{
\code{\link[stats]{anova}}, \code{\link[stats]{chisq.test}}, \code{\link{tableby}}, \code{\link{summary.tableby}}
}

