% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addHooksToPrintGitHub.R
\name{addHooksToPrintGitHub}
\alias{addHooksToPrintGitHub}
\title{Add \pkg{archivist} Hooks to \pkg{rmarkdown} markdown/LaTeX Reports and Archive Artifact on GitHub}
\usage{
addHooksToPrintGitHub(class = "ggplot", repo = aoptions("repo"),
  user = aoptions("user"), password = aoptions("password"),
  format = "markdown")
}
\arguments{
\item{class}{A character containing a name of class (one or more) that should be archived.}

\item{repo}{A character containing a name of a GitHub repository on which the Repository is archived.
If \code{repo = NULL} then hooks will be added to files in local directories.}

\item{user}{A character containing a name of a GitHub user on whose account the \code{repo} is created.}

\item{password}{A character denoting GitHub user password. Can be set globally with \code{aoptions("password", password)}.
See \link{agithub}.}

\item{format}{The same as in \link{alink}.}
}
\description{
\code{addHooksToPrintGitHub} adds an overloaded version of the print function for objects of selected class. 
The overloaded function will add all objects of selected class to the \link{Repository} and then will add hooks to the HTML report (generated in \pkg{rmarkdown}) for these objects (\code{artifacts} - \link{archivist-package}).
This is GitHub version of \code{addHooksToPrint} and it automatically stores artifacts on GitHub - see examples.

This function is well explained on this \href{http://r-bloggers.com/r-hero-saves-backup-city-with-archivist-and-github}{http://r-bloggers.com/r-hero-saves-backup-city-with-archivist-and-github} blog post.
}
\note{
One can specify \code{userTags} as in \link{archive} for artifacts by adding \code{"tags"} attribute.
See note secion about that in \link{archive}.

Bug reports and feature requests can be sent to \href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}
\examples{

\dontrun{
# only in Rmd report, links to GitHub repository and archive artifact
#' # empty GitHub Repository creation
authoriseGitHub(ClientID, ClientSecret) -> github_token
# authoriseGitHub also does: aoptions("github_token", github_token)
aoptions("user", user.name)
aoptions("password", user.password)
createGitHubRepo("Museum", default = TRUE) # it does aoptions("repo", "Museum")

addHooksToPrintGitHub(class="ggplot") # takes default parameters from ?aoptions
qplot(mpg, wt, data = mtcars, geom = "path")
summaryRemoteRepo()
showRemoteRepo()
}
}
\references{
More about \pkg{archivist.github} can be found on 
\href{http://marcinkosinski.github.io/archivist.github/}{marcinkosinski.github.io/archivist.github/} 
and about \pkg{archivist} in posts' history on \href{https://pbiecek.github.io/archivist/articles/posts.html}{https://pbiecek.github.io/archivist/articles/posts.html}
}
\seealso{
Other archivist: \code{\link{archivist-github-integration}}
}
\author{
Przemyslaw Biecek (\link{addHooksToPrint}), \email{przemyslaw.biecek@gmail.com} \cr
Marcin Kosinski (\link{addHooksToPrintGitHub}), \email{m.p.kosinski@gmail.com}
}
